% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia.R
\name{Jack_julia}
\alias{Jack_julia}
\title{Evaluation with Julia}
\usage{
Jack_julia()
}
\value{
A list of functions having the same names as the R functions of this
  package (\code{Jack}, \code{JackPol}, \code{Schur}, etc). The
  \code{XXXPol} functions have an argument \code{poly}, whose possible
  value is \code{"mvp"} or \code{"qspray"} (default), and this is the
  class of the polynomial returned by these functions.
}
\description{
Evaluate the Jack polynomials with Julia. This is highly faster.
}
\note{
See \code{\link[JuliaConnectoR]{JuliaConnectoR-package}} for
  information about setting up Julia. If you want to directly use Julia,
  you can use \href{https://github.com/stla/JackPolynomials.jl}{my package}.
}
\examples{
library(jack)
\donttest{if(JuliaConnectoR::juliaSetupOk()){
  julia <- Jack_julia()
  # numerical evaluation ####
  julia$Jack(x = c(2, 2/3), lambda = c(3, 1), alpha = 3/2)
  # to pass rational numbers, use strings:
  julia$Jack(x = c("2", "2/3"), lambda = c(3, 1), alpha = "3/2")
  # symbolic polynomials ####
  # for `JackPol`, you must pass a rational `alpha` as a string if
  # you want an exact polynomial:
  ( pol <- julia$JackPol(m = 2, lambda = c(3, 1), alpha = "3/2") )
  class(pol)
  JuliaConnectoR::stopJulia()
}}
}
\seealso{
\code{\link{as.function.exactmvp}}
}
