% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_value.R
\name{single_value}
\alias{single_value}
\title{Ensure that a vector has only a single value throughout.}
\usage{
single_value(x, missing = NA, warn_if_all_missing = FALSE, info = NULL)
}
\arguments{
\item{x}{The vector which should have a single value}

\item{missing}{The vector of values to consider missing in \code{x}}

\item{warn_if_all_missing}{Generate a warning if all values are missing?}

\item{info}{If more than one value is found, append this to the warning or
error to assist with determining the location of the issue.}
}
\value{
\code{x} as the scalar single value found throughout (or an error if
  more than one value is found).
}
\description{
Missing values are replaced with the single value, and if all values are
missing, the first value in \code{missing} is used throughout.
}
\examples{
# A simple use case with vectors of input

single_value(c(NA, 1))
# Multiple, different values of missing can be given
single_value(c(NA, "a"), missing = c(NA, "a"))

# A typical use case with a grouped data.frame used for input and the output
# (`B` is guaranteed to have a single value and only one row, in this case)
data.frame(A = rep(1:3, each = 2),
           B = c(rep(4:6, each = 2))) \%>\%
  dplyr::group_by(A) \%>\%
  dplyr::summarize(
    B = single_value(B)
  )

try(
# info is useful to give when multiple values may be found to see what
# grouping variable or what calculation is causing the error
data.frame(A = rep(1:3, each = 2),
           B = c(rep(1:2, each = 2), 1:2)) \%>\%
  dplyr::group_by(A) \%>\%
  dplyr::mutate(
    C = single_value(B, info = paste("Calculating C for group A=", A))
  )
)
}
