% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.hmr.R
\name{diagnostic.hmr}
\alias{diagnostic.hmr}
\title{Diagnostic function for hmr object in jarbes}
\usage{
\method{diagnostic}{hmr}(
  object,
  median.w = 1.5,
  study.names,
  size.forest = 0.4,
  lwd.forest = 0.2,
  shape.forest = 23,
  mu.phi = TRUE,
  mu.phi.x.lim.low = -10,
  mu.phi.x.lim.up = 10,
  ...
)
}
\arguments{
\item{object}{The object generated by the function hmr.}

\item{median.w}{Change color if median of a weight > median.w. The default value is 1.5.}

\item{study.names}{Character vector containing names of the studies used.}

\item{size.forest}{Size of the center symbol mark in the forest-plot lines}

\item{lwd.forest}{Thickness of the lines in the forest-plot}

\item{shape.forest}{Type of symbol for the center mark in the forest-plot lines}

\item{mu.phi}{Also plot the distribution of mu.phi. Default value is TRUE.}

\item{mu.phi.x.lim.low}{Lower limit of the prior to posterior plot for mu.phi}

\item{mu.phi.x.lim.up}{Upper limit of the prior to posterior plot for mu.phi}

\item{...}{\dots}
}
\description{
This function performers a specially designed diagnostic for a hmr object
}
