#' Generic plot function for dpmeta object in jarbes.
#'
#' @param x The object generated by the bmeta function.
#'
#' @param x.lim   Numeric vector of length 2 specifying the x-axis limits.
#' @param y.lim   Numeric vector of length 2 specifying the y-axis limits.
#' @param x.lab  Text with the label of the x-axis.
#' @param y.lab  Text with the label of the y-axis.
#' @param title.plot   Text for setting a title in the plot.
#'
#' @param ... \dots
#'
#' @import ggplot2
#' @importFrom tidyr pivot_longer
#'
#' @export

plot.dpmmeta = function(x,
                       x.lim = c(-3, 3),
                       y.lim = c(0, 2),
                       x.lab = "Treatment Effect: log(OR)",
                       y.lab = "Posterior",
                       title.plot = "Simple Bayesian Meta-Analysis",
                       ...) {
  object = x

  mu = mu.new = Type = NULL

  # Posterior: pooled mean and predictive ..........................

  mu.wide = data.frame(mu = object$BUGSoutput$sims.list$mu,
                       mu.new = object$BUGSoutput$sims.list$mu.new)

  mu.names = c("Pooled TE", "Predictive TE")
  names(mu.wide) = mu.names
  mu.long = pivot_longer(mu.wide, mu.names)
  names(mu.long) = c("Type", "mu")

  plot1 = ggplot(mu.long, aes(x = mu,
                              group = Type,
                              fill = Type,
                              lty = Type))+
    geom_density(alpha=.2, lwd = 1) +
    scale_x_continuous(limits = x.lim ) +
    scale_y_continuous(limits = y.lim )+
    xlab(x.lab)+
    ylab(y.lab)+
    geom_vline(aes(xintercept=0), lty = 2)+
    ggtitle(title.plot)+
    theme_bw()

  return(suppressWarnings(print(plot1)))
  }

