% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\title{Simulate Data for Meta-Analysis}
\usage{
simData(
  mu,
  sigma,
  n.total,
  tau,
  N,
  mu.beta.1,
  mu.beta.2,
  mu.beta.3,
  n.B.1,
  n.B.2,
  n.B.3
)
}
\arguments{
\item{mu}{Scalar with the true pooled effect value.}

\item{sigma}{Scalar with the true intra-study standard deviation.}

\item{n.total}{A vector with the sample sizes of the studies.}

\item{tau}{Scalar with the between-studies standard deviation.}

\item{N}{Scalar with the total number of studies in the meta-analysis.}

\item{mu.beta.1}{Scalar with the mean bias of studies in the mild bias class.}

\item{mu.beta.2}{Scalar with the mean bias of studies in the large bias class.}

\item{mu.beta.3}{Scalar with the mean bias of studies in the extreme bias class.}

\item{n.B.1}{Scalar with the number of studies in the mild bias class.}

\item{n.B.2}{Scalar with the number of studies in the large bias class.}

\item{n.B.3}{Scalar with the number of studies in the extreme bias class.}
}
\value{
A dataframe with columns:
	\item{TE}{Observed study's effect.}
	\item{seTE}{Standard error of the study's effect.}
	\item{theta}{True study's effect.}
	\item{n.total}{Sample size of the study.}
	\item{B.flag}{Bias category: "No B", "Mild B", "Large B", "Extreme B".}
}
\description{
This function simulates aggregated data for a meta-analysis, introducing biased studies at different levels.
}
\examples{

set.seed(123)
simData(mu = 0, sigma = 1, n.total = rep(100, 10), tau = 0.5, N = 10,
        mu.beta.1 = 0.2, mu.beta.2 = 0.5, mu.beta.3 = 1,
        n.B.1 = 2, n.B.2 = 2, n.B.3 = 2)

}
