% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jenga.R, R/main.R
\docType{package}
\name{jenga}
\alias{jenga}
\alias{jenga-package}
\title{jenga: automatic projections of time features using KNN}
\usage{
jenga(
  ts,
  seq_len = NULL,
  k = NULL,
  method = NULL,
  kernel = NULL,
  ci = 0.8,
  deriv = NULL,
  n_windows = 10,
  mode = NULL,
  n_sample = 30,
  search = "random",
  dates = NULL,
  seed = 42
)
}
\arguments{
\item{ts}{A data frame with time features on columns}

\item{seq_len}{Positive integer. Time-step number of the projected sequence}

\item{k}{Positive integer. Number of neighbors to consider when applying kernel average. Min number is 3. Default: NULL (automatic selection).}

\item{method}{Positive integer. Distance method for calculating neighbors. Possibile options are: "euclidean", "manhattan", "chebyshev", "sorensen", "gower", "soergel", "kulczynski_d", "canberra", "lorentzian", "intersection", "non-intersection", "wavehedges", "czekanowski", "motyka", "tanimoto", "ruzicka", "inner_product", "harmonic_mean", "cosine", "hassebrook", "jaccard", "dice",  "fidelity",  "bhattacharyya", "squared_chord", "squared_euclidean", "pearson", "neyman", "squared_chi", "prob_symm", "divergence", "clark", "additive_symm", "taneja", "kumar-johnson", "avg". Default: NULL (automatic selection).}

\item{kernel}{String. DIstribution used to calculate kernel densities. Possible options are: "empirical", "norm", "cauchy", "logis", "unif", "t", "exp", "lnorm". Default: NULL (automatic selection).}

\item{ci}{Confidence interval. Default: 0.8}

\item{deriv}{Integer vector. Number of differentiation operations to perform for each original time feature. 0 = no change; 1: one diff; 2: two diff.}

\item{n_windows}{Positive integer. Number of validation tests to measure/sample error. Default: 10.}

\item{mode}{String. Sequencing method: deterministic ("segmented"), or non-deterministic ("sampled"). Default: NULL (automatic selection).}

\item{n_sample}{Positive integer. Number of samples for grid or random search. Default: 30.}

\item{search}{String. Two option available: "grid", "random". Default: "random".}

\item{dates}{Date. Vector with dates for time features.}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item exploration: list of all not-null models, complete with predictions, test metrics, prediction stats and plot
\item history: a table with the sampled models, hyper-parameters, validation errors, weighted average rank
\item best: results for the best model in term of weighted average rank, including:
\itemize{
\item errors: training and testing errors for one-step and sequence for each ts feature (rmse, mae, mdae, mpe, mape, smape)
\item predictions: min, max, q25, q50, q75, quantiles at selected ci, mean, sd for each ts feature
\item pred_stats: for each predicted time feature, IQR to range, Kullback-Leibler Divergence (compared to previous point in time), upside probability (compared to previous point in time), both averaged across all points in time and compared between the terminal and the first point in the prediction sequence.
}
\item time_log
}
}
\description{
Automatic projections of time features using KNN
}
\examples{
jenga(covid_in_europe[, c(2, 3)], n_sample = 3)
jenga(covid_in_europe[, c(4, 5)], n_sample = 3)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/jenga}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
