% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{check_julia_ok}
\alias{check_julia_ok}
\alias{stop_julia}
\alias{jlme_status}
\alias{jlme_setup}
\title{Set up Julia connection for jlme}
\usage{
check_julia_ok()

stop_julia()

jlme_status()

jlme_setup(..., restart = FALSE, threads = NULL, verbose = interactive())
}
\arguments{
\item{...}{Unused}

\item{restart}{Whether to run \code{stop_julia()} first, before attempting setup}

\item{threads}{Number of threads to start Julia with. Defaults to \code{1}}

\item{verbose}{Whether to alert setup progress. Defaults to \code{interactive()}}
}
\value{
Invisibly returns \code{TRUE} on success
}
\description{
Set up Julia connection for jlme
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check whether Julia installation meets requirements
check_julia_ok()

# Connect to a Julia runtime for use with `{jlme}`
jlme_setup()

# Show information about the Julia runtime
jlme_status()

# Stop Julia runtime
stop_julia()
\dontshow{\}) # examplesIf}
}
