% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmdl.R
\name{modular}
\alias{modular}
\alias{ldFormula}
\alias{OptimizeJmdl}
\alias{JmdlMod}
\title{Modular Functions for Joint Mean Correlation Model Fits}
\usage{
ldFormula(formula, data = NULL, q = 2, theta = NULL, W.appendix = NULL,
  offset = NULL, family = c("Bernoulli", "Nbinom", "Poisson"))

OptimizeJmdl(m, Y, X, W, time, offset = NULL, theta = NULL, family)

JmdlMod(opt, args, std, tval, p, q, family, offset, mc)
}
\arguments{
\item{formula}{a two-sided linear formula object describing the covariates
for both the mean and correlation matrix part of the model, with the response,
the corresponding subject id and measurement time on the left of a operator~,
divided by vertical bars ("|").}

\item{data}{a data frame containing the variables named in formula.}

\item{q}{degree of polynomial of the time lag to model the lower triangular matrix.}

\item{theta}{starting values for the parameters in the model.}

\item{W.appendix}{appendix array to model time-dependent covariates for the lower triangular matrix.}

\item{offset}{a term to be added to a linear predictor.}

\item{family}{the marginal distributions of the discrete variables.
choose 'Bernoulli', 'Poisson' or 'Nbinom'.}

\item{m}{an integer vector of number of measurements for each subject.}

\item{Y}{a matrix of responses for all subjects.}

\item{X}{model matrix for mean structure model.}

\item{W}{model array for the lower triangular matrix.}

\item{time}{a vector of time from the data.}

\item{opt}{optimized results returned by OptimizJmdl.}

\item{args}{arguments returned by ldFormula.}

\item{std}{standard error for parameters.}

\item{tval}{t statistic.}

\item{p}{p.value.}

\item{mc}{matched call from the calling function.}
}
\description{
Modular Functions for joint mean correlation model fits
}
