# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Time series z-normalization
#'
#' @param ts a time series to normalize
#' @param threshold a z-normalization threshold value
#' @useDynLib jmotif
#' @export
#' @references Dina Goldin and Paris Kanellakis,
#' On similarity queries for time-series data: Constraint specification and implementation.
#' In Principles and Practice of Constraint Programming (CP 1995), pages 137-153. (1995)
#' @examples
#' x = seq(0, pi*4, 0.02)
#' y = sin(x) * 5 + rnorm(length(x))
#' plot(x, y, type="l", col="blue")
#' lines(x, znorm(y, 0.01), type="l", col="red")
znorm <- function(ts, threshold = 0.01) {
    .Call('jmotif_znorm', PACKAGE = 'jmotif', ts, threshold)
}

#' Computes the column means for a matrix
#'
#' @param a A matrix to process.
#' @useDynLib jmotif
#' @export
#' @examples
#' x = matrix(rnorm(100), ncol=10)
#' col_means(x)
col_means <- function(a) {
    .Call('jmotif_col_means', PACKAGE = 'jmotif', a)
}

#' Computes a Piecewise Aggregate Approximation (PAA) for a time series
#'
#' @param ts a timeseries to compute the PAA for
#' @param paa_num a desired PAA size.
#' @useDynLib jmotif
#' @export
#' @references Keogh, E., Chakrabarti, K., Pazzani, M., Mehrotra, S.,
#' Dimensionality reduction for fast similarity search in large time series databases.
#' Knowledge and information Systems, 3(3), 263-286. (2001)
#' @examples
#' x = c(-1, -2, -1, 0, 2, 1, 1, 0)
#' plot(x, type = "l", main = "8-points time series and it PAA transform into three points")
#' points(x,pch = 16, lwd = 5)
#' # segments
#' abline(v = c(1, 1+7/3, 1+7/3 * 2, 8), lty = 3, lwd = 2)
paa <- function(ts, paa_num) {
    .Call('jmotif_paa', PACKAGE = 'jmotif', ts, paa_num)
}

#' Get an ASCII letter for an index
#'
#' @param idx The index.
#' @useDynLib jmotif
#' @export
#' @examples
#' # letter 'b'
#' idx_to_letter(2)
idx_to_letter <- function(idx) {
    .Call('jmotif_idx_to_letter', PACKAGE = 'jmotif', idx)
}

#' Get an index for an ASCII letter
#'
#' @param letter The letter.
#' @useDynLib jmotif
#' @export
#' @examples
#' # letter 'b' translates to 2
#' letter_to_idx('b')
letter_to_idx <- function(letter) {
    .Call('jmotif_letter_to_idx', PACKAGE = 'jmotif', letter)
}

#' Get an ASCII indexes sequence for a given string
#'
#' @param str The char array.
#' @useDynLib jmotif
#' @export
#' @examples
#' letters_to_idx(c('a','b','c','a'))
letters_to_idx <- function(str) {
    .Call('jmotif_letters_to_idx', PACKAGE = 'jmotif', str)
}

#' Translates an alphabet size into the array of corresponding SAX cut-lines using the Normal distribution
#'
#' @param a_size the alphabet size, a value between 2 and 20 (inclusive).
#' @useDynLib jmotif
#' @export
#' @references Lonardi, S., Lin, J., Keogh, E., Patel, P.,
#' Finding motifs in time series.
#' In Proc. of the 2nd Workshop on Temporal Data Mining (pp. 53-68). (2002)
#' @examples
#' alphabet_to_cuts(5)
alphabet_to_cuts <- function(a_size) {
    .Call('jmotif_alphabet_to_cuts', PACKAGE = 'jmotif', a_size)
}

#' Transforms a time series into a char array using SAX and the normal alphabet
#'
#' @param ts the timeseries
#' @param a_size the alphabet size
#' @useDynLib jmotif
#' @export
#' @references Lonardi, S., Lin, J., Keogh, E., Patel, P.,
#' Finding motifs in time series.
#' In Proc. of the 2nd Workshop on Temporal Data Mining (pp. 53-68). (2002)
#' @examples
#' y = c(-1, -2, -1, 0, 2, 1, 1, 0)
#' y_paa3 = paa(y, 3)
#' series_to_chars(y_paa3, 3)
series_to_chars <- function(ts, a_size) {
    .Call('jmotif_series_to_chars', PACKAGE = 'jmotif', ts, a_size)
}

#' Transforms a time series into a string
#'
#' @param ts the timeseries
#' @param a_size the alphabet size
#' @useDynLib jmotif
#' @export
#' @references Lonardi, S., Lin, J., Keogh, E., Patel, P.,
#' Finding motifs in time series.
#' In Proc. of the 2nd Workshop on Temporal Data Mining (pp. 53-68). (2002)
#' @examples
#' y = c(-1, -2, -1, 0, 2, 1, 1, 0)
#' y_paa3 = paa(y, 3)
#' series_to_string(y_paa3, 3)
series_to_string <- function(ts, a_size) {
    .Call('jmotif_series_to_string', PACKAGE = 'jmotif', ts, a_size)
}

#' Extracting subseries
#'
#' @param x the timeseries (0-based, left inclusive)
#' @param start the interval start
#' @param end the interval end
#' @useDynLib jmotif
#' @export
#' @examples
#' y = c(-1, -2, -1, 0, 2, 1, 1, 0)
#' subseries(y, 0, 3)
subseries <- function(x, start, end) {
    .Call('jmotif_subseries', PACKAGE = 'jmotif', x, start, end)
}

#' Compares two strings using letters natural ordering
#'
#' @param a the string a
#' @param b the string b
#' @useDynLib jmotif
#' @export
#' @examples
#' is_equal_str("aaa", "bbb")
#' is_equal_str("ccc", "ccc")
is_equal_str <- function(a, b) {
    .Call('jmotif_is_equal_str', PACKAGE = 'jmotif', a, b)
}

#' Discretizes a time series with SAX via sliding window
#'
#' @param ts the timeseries
#' @param w_size the sliding window size
#' @param paa_size the PAA size
#' @param a_size the alphabet size
#' @param nr_strategy the NR strategy
#' @param n_threshold the normalization threshold
#' @useDynLib jmotif
#' @export
#' @references Lonardi, S., Lin, J., Keogh, E., Patel, P.,
#' Finding motifs in time series.
#' In Proc. of the 2nd Workshop on Temporal Data Mining (pp. 53-68). (2002)
sax_via_window <- function(ts, w_size, paa_size, a_size, nr_strategy, n_threshold) {
    .Call('jmotif_sax_via_window', PACKAGE = 'jmotif', ts, w_size, paa_size, a_size, nr_strategy, n_threshold)
}

#' Discretizes a time series with SAX using chunking
#'
#' @param ts the timeseries
#' @param paa_size the PAA size
#' @param a_size the alphabet size
#' @param n_threshold the normalization threshold
#' @useDynLib jmotif
#' @export
#' @references Lonardi, S., Lin, J., Keogh, E., Patel, P.,
#' Finding motifs in time series.
#' In Proc. of the 2nd Workshop on Temporal Data Mining (pp. 53-68). (2002)
sax_by_chunking <- function(ts, paa_size, a_size, n_threshold) {
    .Call('jmotif_sax_by_chunking', PACKAGE = 'jmotif', ts, paa_size, a_size, n_threshold)
}

#' Converts a time series into a wordbag
#'
#' @param ts the timeseries
#' @param w_size the sliding window size
#' @param paa_size the PAA size
#' @param a_size the alphabet size
#' @param nr_strategy the NR strategy
#' @param n_threshold the normalization threshold
#' @useDynLib jmotif
#' @export
#' @references Senin Pavel and Malinchik Sergey,
#' SAX-VSM: Interpretable Time Series Classification Using SAX and Vector Space Model.
#' Data Mining (ICDM), 2013 IEEE 13th International Conference on, pp.1175,1180, 7-10 Dec. 2013.
#' @references Salton, G., Wong, A., Yang., C.,
#' A vector space model for automatic indexing. Commun. ACM 18, 11, 613-620, 1975.
series_to_wordbag <- function(ts, w_size, paa_size, a_size, nr_strategy, n_threshold) {
    .Call('jmotif_series_to_wordbag', PACKAGE = 'jmotif', ts, w_size, paa_size, a_size, nr_strategy, n_threshold)
}

#' Converts a set of time-series into a single wordbag
#'
#' @param data the timeseries data, row-wise
#' @param w_size the sliding window size
#' @param paa_size the PAA size
#' @param a_size the alphabet size
#' @param nr_strategy the NR strategy
#' @param n_threshold the normalization threshold
#' @useDynLib jmotif
#' @export
#' @references Senin Pavel and Malinchik Sergey,
#' SAX-VSM: Interpretable Time Series Classification Using SAX and Vector Space Model.
#' Data Mining (ICDM), 2013 IEEE 13th International Conference on, pp.1175,1180, 7-10 Dec. 2013.
#' @references Salton, G., Wong, A., Yang., C.,
#' A vector space model for automatic indexing. Commun. ACM 18, 11, 613-620, 1975.
manyseries_to_wordbag <- function(data, w_size, paa_size, a_size, nr_strategy, n_threshold) {
    .Call('jmotif_manyseries_to_wordbag', PACKAGE = 'jmotif', data, w_size, paa_size, a_size, nr_strategy, n_threshold)
}

#' Computes a TF-IDF weights matrix for a list of word bags
#'
#' @param data the word-bags list
#' @useDynLib jmotif
#' @export
#' @references Senin Pavel and Malinchik Sergey,
#' SAX-VSM: Interpretable Time Series Classification Using SAX and Vector Space Model.
#' Data Mining (ICDM), 2013 IEEE 13th International Conference on, pp.1175,1180, 7-10 Dec. 2013.
#' @references Salton, G., Wong, A., Yang., C.,
#' A vector space model for automatic indexing. Commun. ACM 18, 11, 613-620, 1975.
#' @examples
#' bag1 = data.frame(
#'    "words" = c("this", "is", "a", "sample"),
#'    "counts" = c(1, 1, 2, 1),
#'    stringsAsFactors = FALSE
#'    )
#' bag2 = data.frame(
#'    "words" = c("this", "is", "another", "example"),
#'    "counts" = c(1, 1, 2, 3),
#'    stringsAsFactors = FALSE
#'    )
#' ll = list("bag1" = bag1, "bag2" = bag2)
#' tfidf = bags_to_tfidf(ll)
bags_to_tfidf <- function(data) {
    .Call('jmotif_bags_to_tfidf', PACKAGE = 'jmotif', data)
}

#' Computes a cosine similarity values between a bag of words and the TF-IDF weight vectors
#'
#' @param data the list containing a word-bag and TF-IDF objects
#' @useDynLib jmotif
#' @export
#' @references Senin Pavel and Malinchik Sergey,
#' SAX-VSM: Interpretable Time Series Classification Using SAX and Vector Space Model.
#' Data Mining (ICDM), 2013 IEEE 13th International Conference on, pp.1175,1180, 7-10 Dec. 2013.
#' @references Salton, G., Wong, A., Yang., C.,
#' A vector space model for automatic indexing. Commun. ACM 18, 11, 613-620, 1975.
cosine_sim <- function(data) {
    .Call('jmotif_cosine_sim', PACKAGE = 'jmotif', data)
}

