
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
descriptivesOptions <- R6::R6Class(
    "descriptivesOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            mean = TRUE,
            median = TRUE,
            mode = FALSE,
            sum = FALSE,
            sd = FALSE,
            variance = FALSE,
            range = FALSE,
            min = TRUE,
            max = TRUE,
            se = FALSE,
            skew = FALSE,
            kurt = FALSE,
            freq = FALSE,
            plots = FALSE,
            plotW = 480,
            plotH = 320,
            quart = FALSE,
            pcEqGr = FALSE,
            pcNEqGr = 4, ...) {

            super$initialize(
                package='jmv',
                name='descriptives',
                requiresData=TRUE,
                ...)
        
            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars)
            private$..mean <- jmvcore::OptionBool$new(
                "mean",
                mean,
                default=TRUE)
            private$..median <- jmvcore::OptionBool$new(
                "median",
                median,
                default=TRUE)
            private$..mode <- jmvcore::OptionBool$new(
                "mode",
                mode,
                default=FALSE)
            private$..sum <- jmvcore::OptionBool$new(
                "sum",
                sum,
                default=FALSE)
            private$..sd <- jmvcore::OptionBool$new(
                "sd",
                sd,
                default=FALSE)
            private$..variance <- jmvcore::OptionBool$new(
                "variance",
                variance,
                default=FALSE)
            private$..range <- jmvcore::OptionBool$new(
                "range",
                range,
                default=FALSE)
            private$..min <- jmvcore::OptionBool$new(
                "min",
                min,
                default=TRUE)
            private$..max <- jmvcore::OptionBool$new(
                "max",
                max,
                default=TRUE)
            private$..se <- jmvcore::OptionBool$new(
                "se",
                se,
                default=FALSE)
            private$..skew <- jmvcore::OptionBool$new(
                "skew",
                skew,
                default=FALSE)
            private$..kurt <- jmvcore::OptionBool$new(
                "kurt",
                kurt,
                default=FALSE)
            private$..freq <- jmvcore::OptionBool$new(
                "freq",
                freq,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..plotW <- jmvcore::OptionInteger$new(
                "plotW",
                plotW,
                default=480,
                hidden=TRUE)
            private$..plotH <- jmvcore::OptionInteger$new(
                "plotH",
                plotH,
                default=320,
                hidden=TRUE)
            private$..quart <- jmvcore::OptionBool$new(
                "quart",
                quart,
                default=FALSE)
            private$..pcEqGr <- jmvcore::OptionBool$new(
                "pcEqGr",
                pcEqGr,
                default=FALSE)
            private$..pcNEqGr <- jmvcore::OptionInteger$new(
                "pcNEqGr",
                pcNEqGr,
                default=4)
        
            self$.addOption(private$..vars)
            self$.addOption(private$..mean)
            self$.addOption(private$..median)
            self$.addOption(private$..mode)
            self$.addOption(private$..sum)
            self$.addOption(private$..sd)
            self$.addOption(private$..variance)
            self$.addOption(private$..range)
            self$.addOption(private$..min)
            self$.addOption(private$..max)
            self$.addOption(private$..se)
            self$.addOption(private$..skew)
            self$.addOption(private$..kurt)
            self$.addOption(private$..freq)
            self$.addOption(private$..plots)
            self$.addOption(private$..plotW)
            self$.addOption(private$..plotH)
            self$.addOption(private$..quart)
            self$.addOption(private$..pcEqGr)
            self$.addOption(private$..pcNEqGr)
        }),
    active = list(
        vars = function() private$..vars$value,
        mean = function() private$..mean$value,
        median = function() private$..median$value,
        mode = function() private$..mode$value,
        sum = function() private$..sum$value,
        sd = function() private$..sd$value,
        variance = function() private$..variance$value,
        range = function() private$..range$value,
        min = function() private$..min$value,
        max = function() private$..max$value,
        se = function() private$..se$value,
        skew = function() private$..skew$value,
        kurt = function() private$..kurt$value,
        freq = function() private$..freq$value,
        plots = function() private$..plots$value,
        plotW = function() private$..plotW$value,
        plotH = function() private$..plotH$value,
        quart = function() private$..quart$value,
        pcEqGr = function() private$..pcEqGr$value,
        pcNEqGr = function() private$..pcNEqGr$value),
    private = list(
        ..vars = NA,
        ..mean = NA,
        ..median = NA,
        ..mode = NA,
        ..sum = NA,
        ..sd = NA,
        ..variance = NA,
        ..range = NA,
        ..min = NA,
        ..max = NA,
        ..se = NA,
        ..skew = NA,
        ..kurt = NA,
        ..freq = NA,
        ..plots = NA,
        ..plotW = NA,
        ..plotH = NA,
        ..quart = NA,
        ..pcEqGr = NA,
        ..pcNEqGr = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
descriptivesResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        descriptives = function() private$..descriptives,
        frequencies = function() private$..frequencies,
        freqPlots = function() private$..freqPlots),
    private = list(
        ..descriptives = NA,
        ..frequencies = NA,
        ..freqPlots = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Descriptives")
            private$..descriptives <- jmvcore::Table$new(
                options=options,
                name="descriptives",
                title="Descriptives",
                rows="(vars)",
                swapRowsColumns=TRUE,
                clearWith=NULL,
                columns=list(
                    list(`name`="name", `title`="", `content`="$key", `type`="text"),
                    list(`name`="n", `title`="N", `type`="integer"),
                    list(`name`="missing", `title`="Missing", `type`="integer"),
                    list(`name`="mean", `title`="Mean", `type`="number", `visible`="(mean)"),
                    list(`name`="median", `title`="Median", `type`="number", `visible`="(median)"),
                    list(`name`="mode", `title`="Mode", `type`="number", `visible`="(mode)"),
                    list(`name`="sum", `title`="Sum", `type`="number", `visible`="(sum)"),
                    list(`name`="sd", `title`="Standard deviation", `type`="number", `visible`="(sd)"),
                    list(`name`="variance", `title`="Variance", `type`="number", `visible`="(variance)"),
                    list(`name`="range", `title`="Range", `type`="number", `visible`="(range)"),
                    list(`name`="min", `title`="Minimum", `type`="number", `visible`="(min)"),
                    list(`name`="max", `title`="Maximum", `type`="number", `visible`="(max)"),
                    list(`name`="se", `title`="Standard error", `type`="number", `visible`="(se)"),
                    list(`name`="skew", `title`="Skewness", `type`="number", `visible`="(skew)"),
                    list(`name`="kurt", `title`="Kurtosis", `type`="number", `visible`="(kurt)"),
                    list(`name`="quart1", `title`="25th percentile", `type`="number", `visible`="(quart)"),
                    list(`name`="quart2", `title`="50th percentile", `type`="number", `visible`="(quart)"),
                    list(`name`="quart3", `title`="75th percentile", `type`="number", `visible`="(quart)")))
            private$..frequencies <- jmvcore::Array$new(
                options=options,
                name="frequencies",
                title="Frequencies",
                visible="(freq)",
                items="(vars)",
                template=jmvcore::Table$new(
                    options=options,
                    title="Frequencies of $key",
                    visible="(levels($key))",
                    clearWith=NULL,
                    rows="(levels($key))",
                    columns=list(
                        list(`name`="level", `title`="Level", `type`="text", `content`="($key)"),
                        list(`name`="counts", `title`="Counts", `type`="number"),
                        list(`name`="percentage", `title`="%", `type`="number"),
                        list(`name`="cumpercentage", `title`="Cumulative %", `type`="number"))))
            private$..freqPlots <- jmvcore::Array$new(
                options=options,
                name="freqPlots",
                title="Plots",
                visible="(plots)",
                items="(vars)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".plotFreq",
                    clearWith=NULL))
            self$add(private$..descriptives)
            self$add(private$..frequencies)
            self$add(private$..freqPlots)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
descriptivesBase <- R6::R6Class(
    "descriptivesBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'descriptives',
                version = c(1,0,0),
                options = options,
                results = descriptivesResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Descriptives
#'
#' Provides a range of descriptive statistics
#'
#' @examples
#' \dontrun{
#' descriptives(data, vars=c('x', 'y', 'z'))
#' }
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in 
#'   \code{data}
#' @param mean \code{TRUE} (default) or \code{FALSE}, provide the mean 
#' @param median \code{TRUE} (default) or \code{FALSE}, provide the median 
#' @param mode \code{TRUE} or \code{FALSE} (default), provide the mode 
#' @param sum \code{TRUE} or \code{FALSE} (default), provide the sum 
#' @param sd \code{TRUE} or \code{FALSE} (default), provide the standard 
#'   deviation 
#' @param variance \code{TRUE} or \code{FALSE} (default), provide the variance 
#' @param range \code{TRUE} or \code{FALSE} (default), provide the range 
#' @param min \code{TRUE} or \code{FALSE} (default), provide the minimum 
#' @param max \code{TRUE} or \code{FALSE} (default), provide the maximum 
#' @param se \code{TRUE} or \code{FALSE} (default), provide the standard error 
#' @param skew \code{TRUE} or \code{FALSE} (default), provide the skewness 
#' @param kurt \code{TRUE} or \code{FALSE} (default), provide the kurtosis 
#' @param freq \code{TRUE} or \code{FALSE} (default), provide frequency tables 
#'   (nominal, ordinal variables only) 
#' @param plots \code{TRUE} or \code{FALSE} (default), provide frequency 
#'   tables (nominal, ordinal variables only) 
#' @param plotW an integer (default: 480) specifying the width of the plots 
#' @param plotH an integer (default: 320) specifying the height of the plots 
#' @param quart \code{TRUE} or \code{FALSE} (default), provide quartiles 
#' @param pcEqGr \code{TRUE} or \code{FALSE} (default), provide quantiles 
#' @param pcNEqGr an integer (default: 4) specifying the number of equal 
#'   groups 
#' @export
descriptives <- function(
    data,
    vars,
    mean = TRUE,
    median = TRUE,
    mode = FALSE,
    sum = FALSE,
    sd = FALSE,
    variance = FALSE,
    range = FALSE,
    min = TRUE,
    max = TRUE,
    se = FALSE,
    skew = FALSE,
    kurt = FALSE,
    freq = FALSE,
    plots = FALSE,
    plotW = 480,
    plotH = 320,
    quart = FALSE,
    pcEqGr = FALSE,
    pcNEqGr = 4) {

    options <- descriptivesOptions$new(
        vars = vars,
        mean = mean,
        median = median,
        mode = mode,
        sum = sum,
        sd = sd,
        variance = variance,
        range = range,
        min = min,
        max = max,
        se = se,
        skew = skew,
        kurt = kurt,
        freq = freq,
        plots = plots,
        plotW = plotW,
        plotH = plotH,
        quart = quart,
        pcEqGr = pcEqGr,
        pcNEqGr = pcNEqGr)

    results <- descriptivesResults$new(
        options = options)

    analysis <- descriptivesClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis$results
}
