% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mancova.h.R
\name{mancova}
\alias{mancova}
\title{MANCOVA}
\usage{
mancova(data, deps, factors = NULL, covs = NULL, multivar = list("pillai",
  "wilks", "hotel", "roy"), boxM = FALSE, shapiro = FALSE, qqPlot = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{deps}{a string naming the dependent variable from \code{data},
variable must be numeric}

\item{factors}{a vector of strings naming the factors from \code{data}}

\item{covs}{a vector of strings naming the covariates from \code{data}}

\item{multivar}{one or more of \code{'pillai'}, \code{'wilks'},
\code{'hotel'}, or \code{'roy'}; use Pillai's Trace, Wilks' Lambda,
Hotelling's Trace, and Roy's Largest Root multivariate statistics,
respectively}

\item{boxM}{\code{TRUE} or \code{FALSE} (default), provide Box's M test}

\item{shapiro}{\code{TRUE} or \code{FALSE} (default), provide Shapiro-Wilk
test}

\item{qqPlot}{\code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
multivariate normality}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$multivar} \tab \tab \tab \tab \tab a table \cr
  \code{results$univar} \tab \tab \tab \tab \tab a table \cr
  \code{results$assump$boxM} \tab \tab \tab \tab \tab a table \cr
  \code{results$assump$shapiro} \tab \tab \tab \tab \tab a table \cr
  \code{results$assump$qqPlot} \tab \tab \tab \tab \tab an image \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$multivar$asDF}

\code{as.data.frame(results$multivar)}
}
\description{
Multivariate Analysis of Covariance
}
\examples{
data('iris')

mancova(data = iris,
    deps = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'),
    factors = 'Species')

#
#  MANCOVA
#
#  Multivariate Tests
#  ---------------------------------------------------------------------------
#                                     value     F       df1    df2    p
#  ---------------------------------------------------------------------------
#    Species    Pillai's Trace          1.19    53.5      8    290    < .001
#               Wilks' Lambda         0.0234     199      8    288    < .001
#               Hotelling's Trace       32.5     581      8    286    < .001
#               Roy's Largest Root      32.2    1167      4    145    < .001
#  ---------------------------------------------------------------------------
#
#
#  Univariate Tests
#  -----------------------------------------------------------------------------------------------
#                 Dependent Variable    Sum of Squares    df     Mean Square    F         p
#  -----------------------------------------------------------------------------------------------
#    Species      Sepal.Length                   63.21      2        31.6061     119.3    < .001
#                 Sepal.Width                    11.34      2         5.6725      49.2    < .001
#                 Petal.Length                  437.10      2       218.5514    1180.2    < .001
#                 Petal.Width                    80.41      2        40.2067     960.0    < .001
#    Residuals    Sepal.Length                   38.96    147         0.2650
#                 Sepal.Width                    16.96    147         0.1154
#                 Petal.Length                   27.22    147         0.1852
#                 Petal.Width                     6.16    147         0.0419
#  -----------------------------------------------------------------------------------------------
#

}
