% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.jointmeta1.R
\name{summary.jointmeta1}
\alias{summary.jointmeta1}
\title{Summary function for jointmeta1}
\usage{
\method{summary}{jointmeta1}(object, variance = TRUE, ...)
}
\arguments{
\item{object}{a jointmeta1.object, the result of fitting a jointmeta1 model}

\item{variance}{a logical if set to \code{TRUE} the variances of the
measurement errors and the random effects are returned, else if
\code{FALSE} then the standard errors are returned.}

\item{...}{additional arguments; currently none are used.}
}
\value{
An object inheriting from class \code{summary.jointmeta1} with all
  components included in \code{object} (see \code{\link{jointmeta1.object}}).
}
\description{
A function to provide a summary of a \code{\link{jointmeta1.object}}.
}
\examples{
   #change example data to jointdata object
   jointdat2<-tojointdata(longitudinal = simdat2$longitudinal,
   survival = simdat2$survival, id = 'id',longoutcome = 'Y',
   timevarying = c('time','ltime'),
   survtime = 'survtime', cens = 'cens',time = 'time')

   #set variables to factors
   jointdat2$baseline$study <- as.factor(jointdat2$baseline$study)
   jointdat2$baseline$treat <- as.factor(jointdat2$baseline$treat)

   #fit multi-study joint model
   #note: for demonstration purposes only - max.it restricted to 5
   #model would need more iterations to truely converge
   onestagefit<-jointmeta1(data = jointdat2, long.formula = Y ~ 1 + time +
                           + treat + study, long.rand.ind = c('int', 'time'),
                           long.rand.stud = c('treat'),
                           sharingstrct = 'randprop',
                           surv.formula = Surv(survtime, cens) ~ treat,
                           study.name = 'study', strat = TRUE, max.it=5)

    #request a summary of the fitted model, with variances printed
    summary(onestagefit, variance = TRUE)

    #request a summary of the fitted model, with standard errors printed
    summary(onestagefit, variance = FALSE)
}
