% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\docType{package}
\name{joinet-package}
\alias{joinet-package}
\title{Multivariate Elastic Net Regression}
\description{
The R package \code{joinet} implements multivariate
ridge and lasso regression using stacked generalisation.
This multivariate regression typically outperforms
univariate regression at predicting correlated outcomes.
It provides predictive and interpretable models
in high-dimensional settings.
}
\details{
Use function \code{\link{joinet}} for model fitting.
Type \code{library(joinet)} and then \code{?joinet} or
\code{help("joinet)"} to open its help file.

See the vignette for further examples.
Type \code{vignette("joinet")} or \code{browseVignettes("joinet")}
to open the vignette.
}
\examples{
#--- data simulation ---
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
# n samples, p inputs, q outputs

#--- model fitting ---
object <- joinet(Y=Y,X=X)
# slot "base": univariate
# slot "meta": multivariate

#--- make predictions ---
y_hat <- predict(object,newx=X)
# n x q matrix "base": univariate
# n x q matrix "meta": multivariate 

#--- extract coefficients ---
coef <- coef(object)
# effects of inputs on outputs
# q vector "alpha": intercepts
# p x q matrix "beta": slopes

#--- model comparison ---
loss <- cv.joinet(Y=Y,X=X)
# cross-validated loss
# row "base": univariate
# row "meta": multivariate

}
\references{
Armin Rauschenberger and Enrico Glaab (2019).
"joinet: predicting correlated outcomes jointly to improve clinical prognosis".
\emph{Manuscript in preparation}.

\email{armin.rauschenberger@uni.lu}
}
\keyword{documentation}
