% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bib2tib.R
\name{read_bib2tib}
\alias{read_bib2tib}
\title{Parse a BibTeX file to a \code{tibble}}
\usage{
read_bib2tib(file)
}
\arguments{
\item{file}{character, path or URL to a bib file.}
}
\value{
A \code{tibble}.
}
\description{
The BibTeX file is read, parsed, tidied and written to a \code{tibble}.
}
\details{
Read, parse and collate bibtex file to form a Tibble. Different BIB may produce different tibble columns.
}
\examples{
# Read from .bib file:
require(journalabbr)
path = system.file("extdata", "testfile_1.bib", package = "journalabbr", mustWork = TRUE)
bib <- read_bib2tib(path)
str(bib)
}
\seealso{
\code{\link{abbrTable}}.
}
\author{
ShuCai Zou
}
