% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{LabeljsRanef}
\alias{LabeljsRanef}
\title{LabeljsRanef: Apply label information to jstable random effect object using label data}
\usage{
LabeljsRanef(obj.ranef, ref)
}
\arguments{
\item{obj.ranef}{ranef of lmer.display, coxme.display, cox2.display}

\item{ref}{Label data made by mk.lev function}
}
\value{
ranef of lmer.display, coxme.display, cox2.display with label information
}
\description{
Apply label information to ranef object of jstable using label data
}
\details{
DETAILS
}
\examples{
library(coxme)
fit <- coxme(Surv(time, status) ~ sex + ph.ecog + ph.karno + (1 | inst) + (1 | sex), lung)
fit.table <- coxme.display(fit)
lung.label <- mk.lev(lung)
LabeljsTable(fit.table$table, ref = lung.label)
LabeljsRanef(fit.table$ranef, ref = lung.label)
}
