% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_jstage_articles.R
\name{get_jstage_articles}
\alias{get_jstage_articles}
\title{Get J-Stage Articles List}
\usage{
get_jstage_articles(
  pubyearfrom = NA,
  pubyearto = NA,
  material = "",
  article = "",
  author = "",
  affil = "",
  keyword = "",
  abst = "",
  text = "",
  issn = "",
  cdjournal = "",
  sortflg = NA,
  vol = NA,
  no = NA,
  start = NA,
  count = NA,
  sep = "\\n",
  lang = "ja"
)
}
\arguments{
\item{pubyearfrom}{An integer specifying the starting publication year (in YYYY format).}

\item{pubyearto}{An integer specifying the ending publication year (in YYYY format).}

\item{material}{A character string specifying the material name (partial match search,
case insensitive).}

\item{article}{A character string specifying the article title (partial match search,
case insensitive).}

\item{author}{A character string specifying the author name (partial match search, case
insensitive).}

\item{affil}{A character string specifying the affiliation (partial match search, case
insensitive).}

\item{keyword}{A character string specifying the keyword (partial match search, case
insensitive).}

\item{abst}{A character string specifying the abstract (partial match search, case
insensitive).}

\item{text}{A character string specifying the full text (partial match search, case
insensitive).}

\item{issn}{A character string specifying the ISSN (exact match search in XXXX-XXXX
format).}

\item{cdjournal}{A character string specifying the journal code.}

\item{sortflg}{An integer specifying the sort flag: 1 for score order, 2 for volume,
issue, and page order (default is 1).}

\item{vol}{An integer specifying the volume (exact match).}

\item{no}{An integer specifying the issue number (exact match).}

\item{start}{An integer specifying the starting index for the search results.}

\item{count}{An integer specifying the number of search results to retrieve (up to
1,000).}

\item{sep}{A character string to separate multiple authors' names. Default is "\\n".}

\item{lang}{A character string specifying the language for column names: "ja" for
Japanese (default is "ja").}
}
\value{
A list containing metadata and entry data frames with the search
results.
}
\description{
Retrieves a list of articles published on J-STAGE, including detailed
information such as publication date and bibliographic metadata.
}
