% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_specList.R
\name{to_specList}
\alias{to_specList}
\title{Producing a list of specifications}
\usage{
to_specList(x, types, type)
}
\arguments{
\item{x}{The list to parse.}

\item{types}{The class to assign to the specification
list (the \code{justifierSpecList} object to return).}

\item{type}{The class to assign to each specification
(in addition to \code{justifierSpec}).}
}
\value{
A list of classes \code{c("justifierSpecList", types)} where
each element is a specification of class
\code{c("justifierSpec", type)}.
}
\description{
This function is for internal use, but has been exported in
case it's useful for people working 'manually' with
lists of justifications.
}
\examples{
### Specify an example text
exampleFile <-
  system.file("extdata",
              "simple-example.jmd",
              package="justifier");

### Show contents
cat(readLines(exampleFile), sep="\\n");

### Load it with yum::load_and_simplify()
loadedMinutes <- yum::load_and_simplify(exampleFile);

### Show contents
names(loadedMinutes);

### Show classes
class(loadedMinutes["assertion"]);

### Convert to specification list
res <- to_specList(loadedMinutes["assertion"],
                   type="assertion",
                   types="assertions");
### Show classes
class(res);

### Show original and parsed objects
loadedMinutes["assertion"];
res;

}
