% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footnote.R
\name{footnote}
\alias{footnote}
\title{Add footnote (new)}
\usage{
footnote(kable_input, general = NULL, number = NULL, alphabet = NULL,
  symbol = NULL, footnote_order = c("general", "number", "alphabet",
  "symbol"), footnote_as_chunk = FALSE, escape = TRUE,
  threeparttable = FALSE, general_title = "Note: ", number_title = "",
  alphabet_title = "", symbol_title = "")
}
\arguments{
\item{kable_input}{HTML or LaTeX table generated by \code{knitr::kable}}

\item{general}{Text for general footnote comments. Footnotes in this section
won't be labeled with any notations}

\item{number}{A vector of footnote texts. Footnotes here will be numbered.
There is no upper cap for the number of footnotes here}

\item{alphabet}{A vector of footnote texts, Footnotes here will be labeled
with abc. The vector here should not have more than 26 elements.}

\item{symbol}{A vector of footnote texts, Footnotes here will be labeled
with special symbols. The vector here should not have more than 20 elements.}

\item{footnote_order}{The order of how to arrange \code{general}, \code{number},
\code{alphabet} and \code{symbol}.}

\item{footnote_as_chunk}{T/F value. Default is FALSE. It controls whether
the footnotes should be printed in a chunk (without line break).}

\item{escape}{T/F value. It controls whether the contents and titles should
be escaped against HTML or LaTeX. Default is TRUE.}

\item{threeparttable}{T/F value for whether to use LaTeX package
threeparttable. Threeparttable will force the width of caption and
footnotes be the width of the original table. It's useful when you have
long paragraph of footnotes.}

\item{general_title}{Section header for general footnotes. Default is
"Note: ".}

\item{number_title}{Section header for number footnotes. Default is "".}

\item{alphabet_title}{Section header for alphabet footnotes. Default is "".}

\item{symbol_title}{Section header for symbol footnotes. Default is "".}
}
\description{
\code{footnote} provides a more flexible way to add footnote. You
can add mutiple sets of footnote using differeny notation system. It is
also possible to specify footnote section header one by one and print
footnotes as a chunk of texts.
}
\examples{
dt <- mtcars[1:5, 1:5]
footnote(knitr::kable(dt, "html"), alphabet = c("Note a", "Note b"))

}
