% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CountApportion-class}
\alias{CountApportion-class}
\alias{.CountApportion}
\title{Count Apportioning}
\description{
An S4 class to represent an artifact apportioning results. Gives the
apportioning of artifact types (columns) per site (rows) and per period
(dim. 3).
}
\section{Slots}{

\describe{
\item{\code{.Data}}{An \eqn{m \times p \times k}{m x p x k} \code{\link{array}} giving the
proportion of an artifact type (\eqn{p}) for a given period (\eqn{k}).}

\item{\code{p}}{An \eqn{m \times p \times k}{m x p x k} \code{\link{array}} giving the
probability of apportioning an artifact type (\eqn{p}) to a given period
(\eqn{k}).}

\item{\code{method}}{A \code{\link{character}} string specifying the distribution used for
apportioning (type popularity curve).}

\item{\code{from}}{A length-one \code{\link{numeric}} vector giving the beginning of the
period of interest (in years AD).}

\item{\code{to}}{A length-one \code{\link{numeric}} vector giving the end of the period of
interest (in years AD).}

\item{\code{step}}{A length-one \code{\link{numeric}} vector giving the step size, i.e. the
width of each time step for apportioning (in years AD).}
}}

\note{
This class inherits from base \code{\link{array}}.
}
\seealso{
Other classes: 
\code{\link{AoristicSum-class}},
\code{\link{EventDate-class}},
\code{\link{IncrementTest-class}},
\code{\link{MeanDate-class}},
\code{\link{PermutationOrder-class}},
\code{\link{RateOfChange-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
