% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kantorovich.R
\name{kantorovich}
\alias{kantorovich}
\title{Kantorovich distance}
\usage{
kantorovich(mu, nu, dist = NULL, details = FALSE, ...)
}
\arguments{
\item{mu}{(row margins) probability measure in numeric or bigq/character mode}

\item{nu}{(column margins) probability measure in numeric or bigq/character mode}

\item{dist}{function or matrix, the distance to be minimized on average;
if \code{NULL}, the 0-1 distance is used.}

\item{details}{prints the joinings achieving the Kantorovich distance and
returns them in the \code{"joinings"} attribute of the output}

\item{...}{arguments passed to \code{dist} (only if it is a function)}
}
\value{
The Kantorovich distance between \code{mu} and \code{nu}.
}
\description{
Compute the Kantorovich distance between two probability measures on a finite set.
}
\details{
The function firstly computes all the extreme joinings of \code{mu}
and \code{nu}, then evaluates the average distance for each of them, and
then returns the minimal one.
}
\examples{
mu <- c(1/7, 2/7, 4/7)
nu <- c(1/4, 1/4, 1/2)
kantorovich(mu, nu)
library(gmp)
mu <- as.bigq(c(1,2,4), 7)
nu <- as.bigq(c(1,1,1), c(4,4,2))
kantorovich(mu, nu)
mu <- c("1/7", "2/7", "4/7")
nu <- c("1/4", "1/4", "1/2")
kantorovich(mu, nu, details=TRUE)

}
