% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/english_wrappers.R
\name{conditions}
\alias{conditions}
\alias{front_is_clear}
\alias{front_is_blocked}
\alias{left_is_clear}
\alias{left_is_blocked}
\alias{right_is_clear}
\alias{right_is_blocked}
\alias{beepers_present}
\alias{no_beepers_present}
\alias{karel_has_beepers}
\alias{karel_has_no_beepers}
\alias{facing_east}
\alias{facing_west}
\alias{facing_north}
\alias{facing_south}
\title{Conditions that Karel can test}
\usage{
front_is_clear()

front_is_blocked()

left_is_clear()

left_is_blocked()

right_is_clear()

right_is_blocked()

beepers_present()

no_beepers_present()

karel_has_beepers()

karel_has_no_beepers()

facing_east()

facing_west()

facing_north()

facing_south()
}
\value{
Logical value TRUE or FALSE.
}
\description{
These group of functions return a logical value \code{TRUE} o \code{FALSE} according to Karel's evaluation of her world.
}
\details{
The functions \code{front_is_clear()}, \code{front_is_blocked()}, \code{left_is_clear()}, \code{left_is_blocked()}, \code{right_is_clear()} y \code{right_is_blocked()} test if there is a wall in front of Karel, to her left or to her right, respectively. The functions \code{beepers_present()} y \code{no_beepers_present()} test if there are or there are not \code{beepers} at Karel's current position. The functions \code{karel_has_beepers()} y \code{karel_has_no_beepers()} test if Karel has or hasn't got  \code{beepers} in her bag (not visible in the plot). The functions \code{facing_east()}, \code{facing_west()}, \code{facing_north()} y \code{facing_south()} test the direction to which Karel is facing right now.
}
\examples{
generate_world("mundo001")
front_is_clear()
front_is_blocked()
left_is_clear()
left_is_blocked()
right_is_clear()
right_is_blocked()
beepers_present()
no_beepers_present()
karel_has_beepers()
karel_has_no_beepers()
facing_east()
facing_west()
facing_north()
facing_south()

}
\seealso{
\code{\link{generate_world}}
}
