% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kcpa.R
\name{kcpa}
\alias{kcpa}
\title{KCP (Kernel Change Point) Detection}
\usage{
kcpa(RunStat, Kmax = 10, wsize = 25)
}
\arguments{
\item{RunStat}{Dataframe of running statistics with rows corresponding to the windows and the
columns corresponding to the variable(s) on which these running statistics were computed.}

\item{Kmax}{Maximum number of change points}

\item{wsize}{Window size}
}
\value{
\item{kcpSoln}{A matrix comprised of the minimized variance criterion \emph{Rmin} and the optimal change point location(s) for each \emph{k} from 1 to \code{Kmax}}
}
\description{
Finds the most optimal change point(s) in the running statistic time series \code{RunStat} by
looking at their kernel-based pairwise similarities.
}
\references{
Arlot, S., Celisse, A., & Harchaoui, Z. (2019). A kernel multiple change-point algorithm via model selection. \emph{Journal of Machine Learning Research}, 20(162), 1-56.

Cabrieto, J., Tuerlinckx, F., Kuppens, P., Grassmann, M., & Ceulemans, E. (2017). Detecting correlation changes in multivariate time series:
         A comparison of four non-parametric change point detection methods. \emph{Behavior Research Methods}, 49, 988-1005. doi:10.3758/s13428-016-0754-9
}
