% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde1d_methods.R
\name{dkde1d}
\alias{dkde1d}
\alias{pkde1d,}
\alias{qkde1d,}
\alias{rkde1d}
\alias{pkde1d}
\alias{qkde1d}
\title{Working with a kde1d object}
\usage{
dkde1d(x, obj)

pkde1d(q, obj)

qkde1d(p, obj)

rkde1d(n, obj, quasi = FALSE)
}
\arguments{
\item{x}{vector of density evaluation points.}

\item{obj}{a \code{kde1d} object.}

\item{q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{integer; number of observations.}

\item{quasi}{logical; the default (\code{FALSE}) returns pseudo-random
numbers, use \code{TRUE} for quasi-random numbers (generalized Halton, see
\code{\link[qrng:ghalton]{qrng::ghalton()}}).}
}
\value{
The density, distribution function or quantile functions estimates
evaluated respectively at \code{x}, \code{q}, or \code{p}, or a sample of \code{n} random
deviates from the estimated kernel density.
}
\description{
Density, distribution function, quantile function and random generation
for a 'kde1d' kernel density estimate.
}
\details{
\code{\link[=dkde1d]{dkde1d()}} gives the density, \code{\link[=pkde1d]{pkde1d()}} gives
the distribution function, \code{\link[=qkde1d]{qkde1d()}} gives the quantile function,
and \code{\link[=rkde1d]{rkde1d()}} generates random deviates.

The length of the result is determined by \code{n} for \code{\link[=rkde1d]{rkde1d()}}, and
is the length of the numerical argument for the other functions.
}
\examples{
set.seed(0)              # for reproducibility
x <- rnorm(100)          # simulate some data
fit <- kde1d(x)          # estimate density
dkde1d(0, fit)           # evaluate density estimate (close to dnorm(0))
pkde1d(0, fit)           # evaluate corresponding cdf (close to pnorm(0))
qkde1d(0.5, fit)         # quantile function (close to qnorm(0))
hist(rkde1d(100, fit))   # simulate

}
\seealso{
\code{\link[=kde1d]{kde1d()}}
}
