% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdevine.R
\name{dkdevine}
\alias{dkdevine}
\title{Evaluate the density of a kdevine object}
\usage{
dkdevine(x, obj)
}
\arguments{
\item{x}{(\eqn{m x d}) matrix of evaluation points (or vector of length \eqn{d}).}

\item{obj}{a \code{kdevine} object.}
}
\value{
The density estimate evaluated at \code{x}.
}
\description{
Evaluate the density of a kdevine object
}
\examples{
# load data
data(wdbc)
\dontshow{wdbc <- wdbc[1:30, ]}
# estimate density (use xmin to indicate positive support)
fit <- kdevine(wdbc[, 5:7], xmin = rep(0, 3))

# evaluate density estimate
dkdevine(c(1000, 0.1, 0.1), fit)

}
\seealso{
\code{\link{kdevine}}
}

