% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations_kendall_rw.R
\name{simulate_kendall_rw}
\alias{simulate_kendall_rw}
\title{Simulate multiple trajectories of Kendall random walk}
\usage{
simulate_kendall_rw(number_of_simulations, trajectory_length, step_dist, alpha,
  symmetric = FALSE, ...)
}
\arguments{
\item{number_of_simulations}{number of trajectories to generate.}

\item{trajectory_length}{length of trajectories.}

\item{step_dist}{function returning random numbers from step dist.}

\item{alpha}{alpha parameter.}

\item{symmetric}{If TRUE, random walk on the whole real line will be simulated.}

\item{...}{parameters for step distribution.}
}
\value{
Object of class kendall_simulation. It is a list that consists of
\item{simulation}{Tibble with simulation id and simulated values,}
\item{step_distribution}{Name of the step distribution,}
\item{alpha}{Value of alpha parameter,}
\item{is_symmetric}{Logical value indicating if this is a symmetric Kendall R.W.}
}
\description{
Object returned by this has print and plot methods.
}
\examples{
kendall_simulations <- simulate_kendall_rw(10, 1000, runif, 0.5)
# Kendall R.W. on positive half-line with uniform step distribution - 10 trajectories.
only_simulations <- kendall_simulations$simulation # tibble with simulated values
kendall_simulations


}
