% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_cast}
\alias{k_cast}
\title{Casts a tensor to a different dtype and returns it.}
\usage{
k_cast(x, dtype)
}
\arguments{
\item{x}{Keras tensor (or variable).}

\item{dtype}{String, either (\code{'float16'}, \code{'float32'}, or \code{'float64'}).}
}
\value{
Keras tensor with dtype \code{dtype}.
}
\description{
You can cast a Keras variable but it still returns a Keras tensor.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

