% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{pad_sequences}
\alias{pad_sequences}
\title{Pads each sequence to the same length (length of the longest sequence).}
\usage{
pad_sequences(sequences, maxlen = NULL, dtype = "int32", padding = "pre",
  truncating = "pre", value = 0)
}
\arguments{
\item{sequences}{List of lists where each element is a sequence}

\item{maxlen}{int, maximum length}

\item{dtype}{type to cast the resulting sequence.}

\item{padding}{'pre' or 'post', pad either before or after each sequence.}

\item{truncating}{'pre' or 'post', remove values from sequences larger than maxlen either in the beginning or in the end of the sequence}

\item{value}{float, value to pad the sequences to the desired value.}
}
\value{
Array with dimensions (number_of_sequences, maxlen)
}
\description{
Pads each sequence to the same length (length of the longest sequence).
}
\details{
If maxlen is provided, any sequence longer than maxlen is truncated to maxlen.
Truncation happens off either the beginning (default) or
the end of the sequence. Supports post-padding and pre-padding (default).
}
\seealso{
Other text preprocessing: \code{\link{make_sampling_table}},
  \code{\link{skipgrams}},
  \code{\link{text_hashing_trick}},
  \code{\link{text_one_hot}},
  \code{\link{text_to_word_sequence}}
}
