% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_unstack}
\alias{k_unstack}
\title{Unstack rank \code{R} tensor into a list of rank \code{R-1} tensors.}
\usage{
k_unstack(x, axis = 1L, num = NULL, name = NULL)
}
\arguments{
\item{x}{a tensor.}

\item{axis}{Axis along which to perform stacking (axis indexes are 1-based).
Negative values wrap around, so the valid range is \verb{[R, -R]}.}

\item{num}{An int. The length of the dimension axis. Automatically inferred
if NULL (the default).}

\item{name}{A name for the operation (optional).}
}
\value{
A tensor.
}
\description{
Unstack rank \code{R} tensor into a list of rank \code{R-1} tensors.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

