% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_lecun_uniform}
\alias{initializer_lecun_uniform}
\title{LeCun uniform initializer.}
\usage{
initializer_lecun_uniform(seed = NULL)
}
\arguments{
\item{seed}{Integer used to seed the random generator.}
}
\description{
It draws samples from a uniform distribution within \code{-limit, limit} where
\code{limit} is \code{sqrt(3 / fan_in)} where \code{fan_in} is the number of input units in
the weight tensor.
}
\section{References}{
 LeCun 98, Efficient Backprop,
}

\seealso{
Other initializers: \code{\link{initializer_constant}},
  \code{\link{initializer_glorot_normal}},
  \code{\link{initializer_glorot_uniform}},
  \code{\link{initializer_he_normal}},
  \code{\link{initializer_he_uniform}},
  \code{\link{initializer_identity}},
  \code{\link{initializer_lecun_normal}},
  \code{\link{initializer_ones}},
  \code{\link{initializer_orthogonal}},
  \code{\link{initializer_random_normal}},
  \code{\link{initializer_random_uniform}},
  \code{\link{initializer_truncated_normal}},
  \code{\link{initializer_variance_scaling}},
  \code{\link{initializer_zeros}}
}
\concept{initializers}
