% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{make_sampling_table}
\alias{make_sampling_table}
\title{Generates a word rank-based probabilistic sampling table.}
\usage{
make_sampling_table(size, sampling_factor = 1e-05)
}
\arguments{
\item{size}{Int, number of possible words to sample.}

\item{sampling_factor}{The sampling factor in the word2vec formula.}
}
\value{
An array of length \code{size} where the ith entry is the
probability that a word of rank i should be sampled.
}
\description{
Generates a word rank-based probabilistic sampling table.
}
\details{
Used for generating the \code{sampling_table} argument for \code{\link[=skipgrams]{skipgrams()}}.
\code{sampling_table[[i]]} is the probability of sampling the word i-th most common
word in a dataset (more common words should be sampled less frequently, for balance).

The sampling probabilities are generated according to the sampling distribution used in word2vec:

\code{p(word) = min(1, sqrt(word_frequency / sampling_factor) / (word_frequency / sampling_factor))}

We assume that the word frequencies follow Zipf's law (s=1) to derive a
numerical approximation of frequency(rank):

\code{frequency(rank) ~ 1/(rank * (log(rank) + gamma) + 1/2 - 1/(12*rank))}

where \code{gamma} is the Euler-Mascheroni constant.
}
\note{
The word2vec formula is: p(word) = min(1,
sqrt(word.frequency/sampling_factor) / (word.frequency/sampling_factor))
}
\seealso{
Other text preprocessing: \code{\link{pad_sequences}},
  \code{\link{skipgrams}},
  \code{\link{text_hashing_trick}},
  \code{\link{text_one_hot}},
  \code{\link{text_to_word_sequence}}
}
\concept{text preprocessing}
