% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_vgg}
\alias{application_vgg}
\alias{application_vgg16}
\alias{application_vgg19}
\title{VGG16 and VGG19 models for Keras.}
\usage{
application_vgg16(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000
)

application_vgg19(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000
)
}
\arguments{
\item{include_top}{whether to include the 3 fully-connected layers at the top
of the network.}

\item{weights}{\code{NULL} (random initialization), \code{imagenet} (ImageNet
weights), or the path to the weights file to be loaded.}

\item{input_tensor}{optional Keras tensor to use as image input for the
model.}

\item{input_shape}{optional shape list, only to be specified if \code{include_top}
is FALSE (otherwise the input shape has to be \verb{(224, 224, 3)} It should
have exactly 3 inputs channels, and width and height should be no smaller
than 32. E.g. \verb{(200, 200, 3)} would be one valid value.}

\item{pooling}{Optional pooling mode for feature extraction when
\code{include_top} is \code{FALSE}.
\itemize{
\item \code{NULL} means that the output of the model will be the 4D tensor output
of the last convolutional layer.
\item \code{avg} means that global average pooling will be applied to the output of
the last convolutional layer, and thus the output of the model will be
a 2D tensor.
\item \code{max} means that global max pooling will be applied.
}}

\item{classes}{optional number of classes to classify images into, only to be
specified if \code{include_top} is TRUE, and if no \code{weights} argument is
specified.}
}
\value{
Keras model instance.
}
\description{
VGG16 and VGG19 models for Keras.
}
\details{
Optionally loads weights pre-trained on ImageNet.

The \code{imagenet_preprocess_input()} function should be used for image preprocessing.
}
\section{Reference}{
 - \href{https://arxiv.org/abs/1409.1556}{Very Deep Convolutional Networks for Large-Scale Image Recognition}
}

\examples{
\dontrun{
library(keras)

model <- application_vgg16(weights = 'imagenet', include_top = FALSE)

img_path <- "elephant.jpg"
img <- image_load(img_path, target_size = c(224,224))
x <- image_to_array(img)
x <- array_reshape(x, c(1, dim(x)))
x <- imagenet_preprocess_input(x)

features <- model \%>\% predict(x)
}
}
