% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_separable_conv2d}
\alias{k_separable_conv2d}
\title{2D convolution with separable filters.}
\usage{
k_separable_conv2d(
  x,
  depthwise_kernel,
  pointwise_kernel,
  strides = c(1, 1),
  padding = "valid",
  data_format = NULL,
  dilation_rate = c(1, 1)
)
}
\arguments{
\item{x}{input tensor}

\item{depthwise_kernel}{convolution kernel for the depthwise convolution.}

\item{pointwise_kernel}{kernel for the 1x1 convolution.}

\item{strides}{strides list (length 2).}

\item{padding}{string, \code{"same"} or \code{"valid"}.}

\item{data_format}{string, \code{"channels_last"} or \code{"channels_first"}.}

\item{dilation_rate}{list of integers, dilation rates for the separable convolution.}
}
\value{
Output tensor.
}
\description{
2D convolution with separable filters.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

