% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_conv_1d}
\alias{layer_conv_1d}
\title{1D convolution layer (e.g. temporal convolution).}
\usage{
layer_conv_1d(
  object,
  filters,
  kernel_size,
  strides = 1L,
  padding = "valid",
  data_format = "channels_last",
  dilation_rate = 1L,
  groups = 1L,
  activation = NULL,
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  bias_constraint = NULL,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{Model or layer object}

\item{filters}{Integer, the dimensionality of the output space (i.e. the
number of output filters in the convolution).}

\item{kernel_size}{An integer or list of a single integer, specifying the
length of the 1D convolution window.}

\item{strides}{An integer or list of a single integer, specifying the stride
length of the convolution. Specifying any stride value != 1 is incompatible
with specifying any \code{dilation_rate} value != 1.}

\item{padding}{One of \code{"valid"}, \code{"causal"} or \code{"same"} (case-insensitive).
\code{"valid"} means "no padding".
\code{"same"} results in padding the input such that the output has the same
length as the original input.
\code{"causal"} results in causal (dilated) convolutions, e.g. \code{output[t]} does
not depend on \verb{input[t+1:]}. Useful when modeling temporal data where the
model should not violate the temporal order. See \href{https://arxiv.org/abs/1609.03499}{WaveNet: A Generative Model for Raw Audio, section 2.1}.}

\item{data_format}{A string, one of \code{"channels_last"} (default) or \code{"channels_first"}.
The ordering of the dimensions in the inputs. \code{"channels_last"} corresponds
to inputs with shape \verb{(batch, length, channels)} (default format for
temporal data in Keras) while \code{"channels_first"} corresponds to inputs
with shape \verb{(batch, channels, length)}.}

\item{dilation_rate}{an integer or list of a single integer, specifying the
dilation rate to use for dilated convolution. Currently, specifying any
\code{dilation_rate} value != 1 is incompatible with specifying any \code{strides}
value != 1.}

\item{groups}{A positive integer specifying the number of groups in which the
input is split along the channel axis. Each group is convolved separately
with \code{filters / groups} filters. The output is the concatenation of all the
groups results along the channel axis. Input channels and \code{filters} must both
be divisible by \code{groups}.}

\item{activation}{Activation function to use. If you don't specify anything,
no activation is applied (ie. "linear" activation: \code{a(x) = x}).}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the kernel matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
This layer creates a convolution kernel that is convolved with the layer
input over a single spatial (or temporal) dimension to produce a tensor of
outputs. If \code{use_bias} is TRUE, a bias vector is created and added to the
outputs. Finally, if \code{activation} is not \code{NULL}, it is applied to the outputs
as well. When using this layer as the first layer in a model, provide an
\code{input_shape} argument (list of integers or \code{NULL }, e.g. \verb{(10, 128)} for
sequences of 10 vectors of 128-dimensional vectors, or \verb{(NULL, 128)} for
variable-length sequences of 128-dimensional vectors.
}
\section{Input shape}{
 3D tensor with shape: \verb{(batch_size, steps, input_dim)}
}

\section{Output shape}{
 3D tensor with shape: \verb{(batch_size, new_steps, filters)} \code{steps} value might have changed due to padding or strides.
}

\seealso{
Other convolutional layers: 
\code{\link{layer_conv_1d_transpose}()},
\code{\link{layer_conv_2d_transpose}()},
\code{\link{layer_conv_2d}()},
\code{\link{layer_conv_3d_transpose}()},
\code{\link{layer_conv_3d}()},
\code{\link{layer_conv_lstm_2d}()},
\code{\link{layer_cropping_1d}()},
\code{\link{layer_cropping_2d}()},
\code{\link{layer_cropping_3d}()},
\code{\link{layer_depthwise_conv_2d}()},
\code{\link{layer_separable_conv_1d}()},
\code{\link{layer_separable_conv_2d}()},
\code{\link{layer_upsampling_1d}()},
\code{\link{layer_upsampling_2d}()},
\code{\link{layer_upsampling_3d}()},
\code{\link{layer_zero_padding_1d}()},
\code{\link{layer_zero_padding_2d}()},
\code{\link{layer_zero_padding_3d}()}
}
\concept{convolutional layers}
