% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-recurrent.R
\name{layer_cudnn_gru}
\alias{layer_cudnn_gru}
\title{Fast GRU implementation backed by \href{https://developer.nvidia.com/cudnn}{CuDNN}.}
\usage{
layer_cudnn_gru(
  object,
  units,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  return_sequences = FALSE,
  return_state = FALSE,
  stateful = FALSE,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{Model or layer object}

\item{units}{Positive integer, dimensionality of the output space.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix, used
for the linear transformation of the inputs.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel} weights
matrix, used for the linear transformation of the recurrent state.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix.}

\item{recurrent_constraint}{Constraint function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{return_sequences}{Boolean. Whether to return the last output in the
output sequence, or the full sequence.}

\item{return_state}{Boolean (default FALSE). Whether to return the last state
in addition to the output.}

\item{stateful}{Boolean (default FALSE). If TRUE, the last state for each
sample at index i in a batch will be used as initial state for the sample
of index i in the following batch.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Can only be run on GPU, with the TensorFlow backend.
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1409.1259}{On the Properties of Neural Machine Translation: Encoder-Decoder Approaches}
\item \href{https://arxiv.org/abs/1412.3555v1}{Empirical Evaluation of Gated Recurrent Neural Networks on Sequence Modeling}
\item \href{https://arxiv.org/abs/1512.05287}{A Theoretically Grounded Application of Dropout in Recurrent Neural Networks}
}
}

\seealso{
Other recurrent layers: 
\code{\link{layer_cudnn_lstm}()},
\code{\link{layer_gru}()},
\code{\link{layer_lstm}()},
\code{\link{layer_simple_rnn}()}
}
\concept{recurrent layers}
