% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict_proba}
\alias{predict_proba}
\alias{predict_classes}
\title{(Deprecated) Generates probability or class probability predictions for the input samples.}
\usage{
predict_proba(object, x, batch_size = NULL, verbose = 0, steps = NULL)

predict_classes(object, x, batch_size = NULL, verbose = 0, steps = NULL)
}
\arguments{
\item{object}{Keras model object}

\item{x}{Input data (vector, matrix, or array). You can also
pass a \code{tfdataset} or a generator returning a list with \verb{(inputs, targets)} or
\verb{(inputs, targets, sample_weights)}.}

\item{batch_size}{Integer. If unspecified, it will default to 32.}

\item{verbose}{Verbosity mode, 0, 1, 2, or "auto". "auto" defaults to 1
for for most cases and defaults to \code{verbose=2} when used with
ParameterServerStrategy or with interactive logging disabled.}

\item{steps}{Total number of steps (batches of samples) before declaring the
evaluation round finished. The default \code{NULL} is equal to the number of
samples in your dataset divided by the batch size.}
}
\description{
These functions were removed in Tensorflow version 2.6. See details for how to update your code:
}
\details{
How to update your code:

\code{predict_proba()}: use \code{predict()} directly.

\code{predict_classes()}:
\itemize{
\item If your model does multi-class classification:
(e.g. if it uses a \code{softmax} last-layer activation).
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{     model \%>\% predict(x) \%>\% k_argmax()
}\if{html}{\out{</div>}}
\itemize{
\item if your model does binary classification
(e.g. if it uses a \code{sigmoid} last-layer activation).
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{     model \%>\% predict(x) \%>\% `>`(0.5) \%>\% k_cast("int32")
}\if{html}{\out{</div>}}

The input samples are processed batch by batch.
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{fit_generator}()},
\code{\link{get_config}()},
\code{\link{get_layer}()},
\code{\link{keras_model_sequential}()},
\code{\link{keras_model}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
\keyword{internal}
