% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-training.R
\name{evaluate.keras.src.models.model.Model}
\alias{evaluate.keras.src.models.model.Model}
\title{Evaluate a Keras Model}
\usage{
\method{evaluate}{keras.src.models.model.Model}(
  object,
  x = NULL,
  y = NULL,
  ...,
  batch_size = NULL,
  verbose = getOption("keras.verbose", default = "auto"),
  sample_weight = NULL,
  steps = NULL,
  callbacks = NULL
)
}
\arguments{
\item{object}{Keras model object}

\item{x}{Input data. It could be:
\itemize{
\item An R array (or array-like), or a list of arrays
(in case the model has multiple inputs).
\item A tensor, or a list of tensors
(in case the model has multiple inputs).
\item A named list mapping input names to the corresponding array/tensors,
if the model has named inputs.
\item A \code{tf.data.Dataset}. Should return a tuple
of either \verb{(inputs, targets)} or
\verb{(inputs, targets, sample_weights)}.
\item A generator returning
\verb{(inputs, targets)} or \verb{(inputs, targets, sample_weights)}.
}}

\item{y}{Target data. Like the input data \code{x}, it could be either R
array(s) or backend-native tensor(s).
If \code{x} is a \code{tf.data.Dataset} or generator function,
\code{y} should not be specified
(since targets will be obtained from the iterator/dataset).}

\item{...}{For forward/backward compatability.}

\item{batch_size}{Integer or \code{NULL}. Number of samples per batch of
computation. If unspecified, \code{batch_size} will default to \code{32}. Do
not specify the \code{batch_size} if your data is in the form of a
a tf dataset or generator
(since they generate batches).}

\item{verbose}{\code{"auto"}, \code{0}, \code{1}, or \code{2}. Verbosity mode.
\code{0} = silent, \code{1} = progress bar, \code{2} = single line.
\code{"auto"} becomes \code{1} for most cases,
\code{2} if in a knitr render or running on a distributed training server.
Note that the progress bar is not
particularly useful when logged to a file, so \code{verbose=2} is
recommended when not running interactively
(e.g. in a production environment). Defaults to \code{"auto"}.}

\item{sample_weight}{Optional array of weights for the test samples,
used for weighting the loss function. You can either pass a flat
(1D) R array with the same length as the input samples
(1:1 mapping between weights and samples), or in the case of
temporal data, you can pass a 2D array with shape \verb{(samples, sequence_length)}, to apply a different weight to every
timestep of every sample. This argument is not supported when
\code{x} is a tfdataset, instead pass sample weights as the third
element of \code{x}.}

\item{steps}{Integer or \code{NULL}. Total number of steps (batches of samples)
before declaring the evaluation round finished. Ignored with the
default value of \code{NULL}. If \code{x} is a \code{tf.data.Dataset} and
\code{steps} is \code{NULL}, evaluation will run until the dataset
is exhausted.}

\item{callbacks}{List of \code{Callback} instances.
List of callbacks to apply during evaluation.}
}
\value{
Scalar test loss (if the model has a single output and no metrics)
or list of scalars (if the model has multiple outputs
and/or metrics). The attribute \code{model$metrics_names} will give you
the display labels for the scalar outputs.
}
\description{
This functions returns the loss value and metrics values for the model in
test mode.
Computation is done in batches (see the \code{batch_size} arg.)
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_training_apis#evaluate-method}
}

Other model training: \cr
\code{\link{compile.keras.src.models.model.Model}()} \cr
\code{\link{predict.keras.src.models.model.Model}()} \cr
\code{\link{predict_on_batch}()} \cr
\code{\link{test_on_batch}()} \cr
\code{\link{train_on_batch}()} \cr
}
\concept{model training}
