% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-attention.R
\name{layer_group_query_attention}
\alias{layer_group_query_attention}
\title{Grouped Query Attention layer.}
\usage{
layer_group_query_attention(
  object,
  head_dim,
  num_query_heads,
  num_key_value_heads,
  dropout = 0,
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  bias_constraint = NULL,
  ...
)
}
\arguments{
\item{object}{Object to compose the layer with. A tensor, array, or sequential model.}

\item{head_dim}{Size of each attention head.}

\item{num_query_heads}{Number of query attention heads.}

\item{num_key_value_heads}{Number of key and value attention heads.}

\item{dropout}{Dropout probability.}

\item{use_bias}{Boolean, whether the dense layers use bias vectors/matrices.}

\item{kernel_initializer}{Initializer for dense layer kernels.}

\item{bias_initializer}{Initializer for dense layer biases.}

\item{kernel_regularizer}{Regularizer for dense layer kernels.}

\item{bias_regularizer}{Regularizer for dense layer biases.}

\item{activity_regularizer}{Regularizer for dense layer activity.}

\item{kernel_constraint}{Constraint for dense layer kernels.}

\item{bias_constraint}{Constraint for dense layer kernels.}

\item{...}{For forward/backward compatability.}
}
\value{
attention_output: Result of the computation, of shape
\verb{(batch_dim, target_seq_len, feature_dim)}, where \code{target_seq_len}
is for target sequence length and \code{feature_dim} is the query input
last dim.
attention_scores: (Optional) attention coefficients of shape
\verb{(batch_dim, num_query_heads, target_seq_len, source_seq_len)}.
}
\description{
This is an implementation of grouped-query attention introduced by
\href{https://arxiv.org/abs/2305.13245}{Ainslie et al., 2023}. Here
\code{num_key_value_heads} denotes number of groups, setting
\code{num_key_value_heads} to 1 is equivalent to multi-query attention, and
when \code{num_key_value_heads} is equal to \code{num_query_heads} it is equivalent
to multi-head attention.

This layer first projects \code{query}, \code{key}, and \code{value} tensors. Then, \code{key}
and \code{value} are repeated to match the number of heads of \code{query}.

Then, the \code{query} is scaled and dot-producted with \code{key} tensors. These are
softmaxed to obtain attention probabilities. The value tensors are then
interpolated by these probabilities and concatenated back to a single
tensor.
}
\section{Call Arguments}{
\itemize{
\item \code{query}: Query tensor of shape \verb{(batch_dim, target_seq_len, feature_dim)},
where \code{batch_dim} is batch size, \code{target_seq_len} is the length of
target sequence, and \code{feature_dim} is dimension of feature.
\item \code{value}: Value tensor of shape \verb{(batch_dim, source_seq_len, feature_dim)},
where \code{batch_dim} is batch size, \code{source_seq_len} is the length of
source sequence, and \code{feature_dim} is dimension of feature.
\item \code{key}: Optional key tensor of shape
\verb{(batch_dim, source_seq_len, feature_dim)}. If not given, will use
\code{value} for both \code{key} and \code{value}, which is most common case.
\item \code{attention_mask}: A boolean mask of shape
\verb{(batch_dim, target_seq_len, source_seq_len)}, that prevents
attention to certain positions. The boolean mask specifies which
query elements can attend to which key elements, where 1 indicates
attention and 0 indicates no attention. Broadcasting can happen for
the missing batch dimensions and the head dimension.
\item \code{return_attention_scores}: A boolean to indicate whether the output
should be \verb{(attention_output, attention_scores)} if \code{TRUE}, or
\code{attention_output} if \code{FALSE}. Defaults to \code{FALSE}.
\item \code{training}: Python boolean indicating whether the layer should behave in
training mode (adding dropout) or in inference mode (no dropout).
Will go with either using the training mode of the parent
layer/model or \code{FALSE} (inference) if there is no parent layer.
\item \code{use_causal_mask}: A boolean to indicate whether to apply a causal mask to
prevent tokens from attending to future tokens (e.g., used in a
decoder Transformer).
}
}

\seealso{
Other attention layers: \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_multi_head_attention}()} \cr

Other layers: \cr
\code{\link{Layer}()} \cr
\code{\link{layer_activation}()} \cr
\code{\link{layer_activation_elu}()} \cr
\code{\link{layer_activation_leaky_relu}()} \cr
\code{\link{layer_activation_parametric_relu}()} \cr
\code{\link{layer_activation_relu}()} \cr
\code{\link{layer_activation_softmax}()} \cr
\code{\link{layer_activity_regularization}()} \cr
\code{\link{layer_add}()} \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_alpha_dropout}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_average}()} \cr
\code{\link{layer_average_pooling_1d}()} \cr
\code{\link{layer_average_pooling_2d}()} \cr
\code{\link{layer_average_pooling_3d}()} \cr
\code{\link{layer_batch_normalization}()} \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_category_encoding}()} \cr
\code{\link{layer_center_crop}()} \cr
\code{\link{layer_concatenate}()} \cr
\code{\link{layer_conv_1d}()} \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_cropping_1d}()} \cr
\code{\link{layer_cropping_2d}()} \cr
\code{\link{layer_cropping_3d}()} \cr
\code{\link{layer_dense}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_discretization}()} \cr
\code{\link{layer_dot}()} \cr
\code{\link{layer_dropout}()} \cr
\code{\link{layer_einsum_dense}()} \cr
\code{\link{layer_embedding}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_flatten}()} \cr
\code{\link{layer_flax_module_wrapper}()} \cr
\code{\link{layer_gaussian_dropout}()} \cr
\code{\link{layer_gaussian_noise}()} \cr
\code{\link{layer_global_average_pooling_1d}()} \cr
\code{\link{layer_global_average_pooling_2d}()} \cr
\code{\link{layer_global_average_pooling_3d}()} \cr
\code{\link{layer_global_max_pooling_1d}()} \cr
\code{\link{layer_global_max_pooling_2d}()} \cr
\code{\link{layer_global_max_pooling_3d}()} \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_hashed_crossing}()} \cr
\code{\link{layer_hashing}()} \cr
\code{\link{layer_identity}()} \cr
\code{\link{layer_integer_lookup}()} \cr
\code{\link{layer_jax_model_wrapper}()} \cr
\code{\link{layer_lambda}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_masking}()} \cr
\code{\link{layer_max_pooling_1d}()} \cr
\code{\link{layer_max_pooling_2d}()} \cr
\code{\link{layer_max_pooling_3d}()} \cr
\code{\link{layer_maximum}()} \cr
\code{\link{layer_mel_spectrogram}()} \cr
\code{\link{layer_minimum}()} \cr
\code{\link{layer_multi_head_attention}()} \cr
\code{\link{layer_multiply}()} \cr
\code{\link{layer_normalization}()} \cr
\code{\link{layer_permute}()} \cr
\code{\link{layer_random_brightness}()} \cr
\code{\link{layer_random_contrast}()} \cr
\code{\link{layer_random_crop}()} \cr
\code{\link{layer_random_flip}()} \cr
\code{\link{layer_random_rotation}()} \cr
\code{\link{layer_random_translation}()} \cr
\code{\link{layer_random_zoom}()} \cr
\code{\link{layer_repeat_vector}()} \cr
\code{\link{layer_rescaling}()} \cr
\code{\link{layer_reshape}()} \cr
\code{\link{layer_resizing}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_spatial_dropout_1d}()} \cr
\code{\link{layer_spatial_dropout_2d}()} \cr
\code{\link{layer_spatial_dropout_3d}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_string_lookup}()} \cr
\code{\link{layer_subtract}()} \cr
\code{\link{layer_text_vectorization}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{layer_unit_normalization}()} \cr
\code{\link{layer_upsampling_1d}()} \cr
\code{\link{layer_upsampling_2d}()} \cr
\code{\link{layer_upsampling_3d}()} \cr
\code{\link{layer_zero_padding_1d}()} \cr
\code{\link{layer_zero_padding_2d}()} \cr
\code{\link{layer_zero_padding_3d}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr
}
\concept{attention layers}
\concept{layers}
