% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-training.R
\name{train_on_batch}
\alias{train_on_batch}
\title{Runs a single gradient update on a single batch of data.}
\usage{
train_on_batch(object, x, y = NULL, sample_weight = NULL, class_weight = NULL)
}
\arguments{
\item{object}{Keras model object}

\item{x}{Input data. Must be array-like.}

\item{y}{Target data. Must be array-like.}

\item{sample_weight}{Optional array of the same length as x, containing
weights to apply to the model's loss for each sample.
In the case of temporal data, you can pass a 2D array
with shape \verb{(samples, sequence_length)}, to apply a different
weight to every timestep of every sample.}

\item{class_weight}{Optional named list mapping class indices (integers, 0-based)
to a weight (float) to apply to the model's loss for the samples
from this class during training. This can be useful to tell the
model to "pay more attention" to samples from an
under-represented class. When \code{class_weight} is specified
and targets have a rank of 2 or greater, either \code{y} must
be one-hot encoded, or an explicit final dimension of 1
must be included for sparse class labels.}
}
\value{
A scalar loss value (when no metrics),
or a named list of loss and metric values
(if there are metrics).
The property \code{model$metrics_names}
will give you the display labels for the scalar outputs.
}
\description{
Runs a single gradient update on a single batch of data.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_training_apis#trainonbatch-method}
}

Other model training: \cr
\code{\link{compile.keras.src.models.model.Model}()} \cr
\code{\link{evaluate.keras.src.models.model.Model}()} \cr
\code{\link{predict.keras.src.models.model.Model}()} \cr
\code{\link{predict_on_batch}()} \cr
\code{\link{test_on_batch}()} \cr
}
\concept{model training}
