% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ktx.kdpi.optn.R
\name{ktx.kdpi.optn}
\alias{ktx.kdpi.optn}
\title{Calculate KDRI and KDPI for deceased kidney donor}
\usage{
ktx.kdpi.optn(age, height_cm = 0, height_ft = 0, height_inch = 0,
  weight_kg = 0, weight_lb = 0, ethnicity, hypertension, diabetes,
  causeofdeath, creatinine, hcv, dcdstatus,
  creatinine_units = "micromol/l", return_output_type = "KDPI",
  mapping_values_year = "latest",
  label_afroamerican = c("Afroamerican"),
  label_hypertension_positive = c("yes"),
  label_hypertension_unknown = "NA",
  label_diabetes_positive = c("yes"), label_diabetes_unknown = "NA",
  label_causeofdeath = c("cva"), label_hcv_positive = c("positive"),
  label_hcv_unknown = "NA", label_dcdstatus = c("yes"))
}
\arguments{
\item{age}{Numeric vector. Age, in years.}

\item{height_cm}{Numeric vector. Could be defined either as height_cm if is measured in cm, or as height_ft and height_inch if is measured in feet and inches.
If the parameter height_cm is greater than 0, the function uses cm, otherwise - feet and inches.}

\item{height_ft}{see height_cm}

\item{height_inch}{see height_cm}

\item{weight_kg}{Numeric vector. Could be defined either as weight_kg if measured in kg, or as weight_lb if is measured in pounds.
If the parameter weight_kg is greater than 0, the function uses kg, otherwise - pounds.}

\item{weight_lb}{see weight_kg}

\item{ethnicity}{Vector. Ethnicity, specify in case of African-American donors which have special coefficient in the regression equation. The value of variable refers to the parameter label_afroamerican.}

\item{hypertension}{Vector. History of hypertension, specify in case of hypertensive donors which have special coefficient in the regression equation. The value of variable refers to the parameters label_hypertension_positive and label_hypertension_unknown.}

\item{diabetes}{Vector. History of diabetes, specify in case of donors with diabetes which have special coefficient in the regression equation. The value of variable refers to the parameters label_diabetes_positive and label_diabetes_unknown.}

\item{causeofdeath}{Vector. Cause of death, specify whether death was due to cerebrovascular disease, or other reasons.}

\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{hcv}{Vector. Hepatitis C virus status. The value of variable refers to the parameters label_hcv_positive and label_hcv_unknown.}

\item{dcdstatus}{Vector. Donation after circulatory death status. Specify whether organ was from a donor after circulatory death or not. The value of variable refers to the parameter label_dcdstatus.}

\item{creatinine_units}{Character string. Units in which serum creatinne is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{return_output_type}{Character string. Specify which calculated parameter to return from the function: "KDRI_Rao" - Raw Kidney Donor Risk Index, "KDRI_median" - scaled to the median Kidney Donor Risk Index, or "KDPI" - Kidney Donor Profile Index.}

\item{mapping_values_year}{Numeric value or character string.  Specify which year to take for the OPTN mapping table, as well as KDRI scaling factor and chances of hypertension and diabetes in case if they were unknown for donor.

By default the value is "latest", and the function takes the latest available OPTN mapping table and coefficients from the internal dataframes ktx.kdpi_mapping_table and ktx.kdpi_coefficients_table.

But if necessary, a user could define the exact year (i.e. mapping_values_year = 2015).

For a list of available years run the following: ktx.kdpi.optn.show.years().}

\item{label_afroamerican}{List. Label(s) for Afroamerican ethnicity.}

\item{label_hypertension_positive}{List. Label(s) for a positive history of hypertension.}

\item{label_hypertension_unknown}{List. Label(s) for donors with unknown history of hypertension.}

\item{label_diabetes_positive}{List. Label(s) for a positive history of diabetes.}

\item{label_diabetes_unknown}{List. Label(s) for donors with unknown history of diabetes.}

\item{label_causeofdeath}{List. Label(s) for a cause of death due to cerebrovascular/stroke.}

\item{label_hcv_positive}{List. Label(s) for a positive HCV status.}

\item{label_hcv_unknown}{List. Label(s) for an unknown, not done, indeterminate, or pending HCV status.}

\item{label_dcdstatus}{List. Label(s) for a donor after circulatory death status.}
}
\value{
numeric One of the following values based on the return_output_type argument: Raw Kidney Donor Risk Index (KDRI), Scaled to the median Kidney Donor Risk Index (KDRI), or Kidney Donor Profile Index (KDPI).
}
\description{
Calculate KDRI and KDPI for deceased kidney donor
}
\details{
Calculate Kidney Donor Risk Index (KDRI) and Kidney Donor Profile Index (KDPI) based on the algorithm of US Organ Procurement and Transplantation Network. 
The Kidney Donor Profile Index (KDPI) is a numerical measure that combines ten donor factors to summarize into a single number the quality of deceased donor kidneys relative to other recovered kidneys. 
\emph{KDRI could be calculated only for a deceased donor}!

More reading:
\itemize{
  \item \href{https://optn.transplant.hrsa.gov/resources/allocation-calculators/kdpi-calculator/}{OPTN web-based calculator}
  \item \href{https://optn.transplant.hrsa.gov/media/1512/guide_to_calculating_interpreting_kdpi.pdf}{Guide to calculating and interpreting KDPI}
  \item \href{https://optn.transplant.hrsa.gov/media/2150/kdpi_mapping_table.pdf}{Latest data for mapping table, scaling factor, etc}
}

Programming: Boris Bikbov \email{boris@bikbov.ru}.

Citation: Bikbov B. R open source programming code for calculation of the Kidney Donor Profile Index and Kidney Donor Risk Index. Kidney Diseases, 2018. DOI: 10.1159/000492427
}
\examples{
ktx.kdpi.optn (age = 60, height_cm = 168, weight_kg = 93, ethnicity = "White",
  hypertension = "yes", diabetes = "no", causeofdeath = "roadinjury",
  creatinine = 1.4, hcv = "negative", dcdstatus = "no",
  creatinine_units = "mg/dl", return_output_type = "KDRI_Rao")
ktx.kdpi.optn (age = 30, height_cm = 176, weight_kg = 82, ethnicity = "White", 
  hypertension = "NA", diabetes = "no", causeofdeath = "roadinjury", 
  creatinine = 150, hcv = "negative", dcdstatus = "no", return_output_type = "KDPI")
}
