% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vswitch.R
\name{vswitch}
\alias{vswitch}
\title{Vectorized switch}
\usage{
vswitch(EXPR, ...)
}
\arguments{
\item{EXPR}{an expression evaluating to a number or a character
    string.}

\item{...}{the list of alternatives.  If it is intended that
    \code{EXPR} has a character-string value these will be
    named, perhaps except for one alternative to be used as a
    \sQuote{default} value.}
}
\value{
The value of one of the elements of \code{...},
  or \code{NA} whenever no element is selected.
  Contrary to \code{\link[base]{switch}} the result is
  always visible.
}
\description{
The function \code{vswitch} is a vectorized version of
  \code{\link[base]{switch}} optimized for performance.
}
\details{
Only the \code{EXPR} argument is treated as a vector. In particular,
if any of the alternatives (or the default alternative) is a vector, the
result will be a list of vectors.
}

