% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thisfile.R
\name{thisfile-deprecated}
\alias{thisfile-deprecated}
\alias{thisfile}
\alias{thisfile_source}
\alias{thisfile_r}
\alias{thisfile_rscript}
\alias{thisfile_knit}
\title{Determines the path of the currently running script}
\usage{
thisfile()

thisfile_source()

thisfile_r()

thisfile_rscript()

thisfile_knit()
}
\value{
The path of the currently running script, NULL if it cannot be
determined.
}
\description{
\R does not store nor export the path of the currently running
script.  This is an attempt to circumvent this limitation by applying
heuristics (such as call stack and argument inspection) that work in many
cases.
}
\details{
This functions currently work only if the script was \code{source}d,
processed with \code{knitr},
or run with \code{Rscript} or using the \code{--file} parameter to the
\code{R} executable.  For code run with \code{Rscript}, the exact value
of the parameter passed to \code{Rscript} is returned.
}
\examples{
\dontrun{thisfile()}
}
\references{
\url{http://stackoverflow.com/q/1815606/946850}
}
\seealso{
\code{\link[base:source]{base::source()}}, \code{\link[utils:Rscript]{utils::Rscript()}}, \code{\link[base:getwd]{base::getwd()}}

Other deprecated functions: \code{\link{coalesce.na-deprecated}},
  \code{\link{df_to_list-deprecated}},
  \code{\link{hms.to.seconds-deprecated}},
  \code{\link{kimisc-deprecated}},
  \code{\link{list_to_df-deprecated}},
  \code{\link{nc-deprecated}},
  \code{\link{nlist-deprecated}},
  \code{\link{ofactor-deprecated}},
  \code{\link{sample.rows-deprecated}},
  \code{\link{seconds.to.hms-deprecated}},
  \code{\link{tll-deprecated}},
  \code{\link{vswitch-deprecated}}
}
\author{
Kirill Müller, Hadley Wickham, Michael R. Head
}
