% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_kinpairs.R
\name{df_to_kinpair}
\alias{df_to_kinpair}
\title{Convert dataframe or tibble to \code{\link{KinPairData}} class}
\usage{
df_to_kinpair(data, kinship = NULL, lifestage = NULL, lifecheck = TRUE)
}
\arguments{
\item{data}{data.frame or tibble of kin distances - can contain $distance (kin distances), $kinship (kin cats) & $lifestage columns}

\item{kinship}{character. kin category to assign or extract from data. one of PO, FS, HS, AV, GG, HAV, GGG, 1C, 1C1, 2C, GAV, HGAV, H1C , H1C1 or H2C}

\item{lifestage}{character. lifestage to assign or extract from data. one of 'unknown', 'immature' or 'ovipositional'.}

\item{lifecheck}{logical. If TRUE (default) tests if lifestage is valid, if FALSE, ignores this test. Set to FALSE when using custom lifestages.}
}
\value{
returns valid \code{KinPairData} object
}
\description{
This function at minimum requires the dataframe to contain a column titled 'distance' containing distances
between kin pairs. It can optionally contain a column of kinship values 'kinship' as well as a column of lifestage values 'lifestage'.
If the file contains more than one value in the kinship or lifestage columns (e.g. bot 'FS' and 'HS') - the corresponding function
parameter must be set to pick a corresponding subset of dispersed pairs. where parameters are set in the absence of file columns,
these values are assigned to the returned \code{KinPairData} object.
}
\examples{
mydata <- tibble::tibble(
  distance = 1:10, lifestage = "immature",
  kinship = c("FS", "FS", "FS", "FS", "FS", "FS", "HS", "HS", "HS", "HS")
)
df_to_kinpair(mydata, kinship = "FS")
}
\seealso{
Other import_functions: 
\code{\link{csv_to_kinpair}()},
\code{\link{read_kindata}()},
\code{\link{tsv_to_kinpair}()},
\code{\link{vector_to_kinpair}()}
}
\concept{import_functions}
