% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{cross_spectrum}
\alias{cross_spectrum}
\alias{cross_spectrum.mts}
\alias{cross_spectrum.default}
\title{Calculate the cross-spectrum of two timeseries}
\usage{
cross_spectrum(x, ...)

\method{cross_spectrum}{mts}(x, ...)

\method{cross_spectrum}{default}(x, y, k = 10, samp = 1, q,
  verbose = TRUE, ...)
}
\arguments{
\item{x}{numeric; timeseries}

\item{...}{additional arguments to \code{\link[sapa]{SDF}}}

\item{y}{numeric; timeseries. if missing, assumed to be column no. 2 in \code{x}}

\item{k}{integer; the number of sine tapers, unless this is \code{NULL}; in the latter case
a Welch-based spectrum is calculated rather than a multitaper spectrum. There are distinct
advantages and disadvantages to either of these.}

\item{samp}{numeric; the sampling rate (e.g., \code{\link{deltat}}) of the data; must be the same for \code{x} and \code{y}}

\item{q}{numeric; the probability quantile [0,1] to calculate coherence significance levels; if missing, a 
pre-specified sequence is included. This is will be ignored for Welch-based spectra (see \code{k}).}

\item{verbose}{logical; should messages be printed?}
}
\description{
Calculate the cross-spectrum of two timeseries
}
\examples{
require(stats)

n <- 1000
ramp <- seq_len(n)
parab <- ramp^2

set.seed(1255)
X <- ts(rnorm(n) + ramp/2)
Y <- ts(rnorm(n) + ramp/10 + parab/100)

# Calculate the cross spectrum, multitaper if K is not NULL
csd <- cross_spectrum(X, Y, k=20)

with(csd,{
  x <- Frequency
  px <- c(x, rev(x))
  
  y1 <- y1s <- Coherence
  cpr <- attr(csd, 'mtcsd')[['Coh.probs']]
  sig99 <- max(cpr$coh.sig) # 99\% confidence
  insig <- y1 < sig99
  y1s[insig] <- NA
  plot(x, y1, col=NA, main='Coherence')
  lines(x, y1, col='grey')
  lines(x, y1s)
  
  y2 <- y2s <- Admittance
  y2e <- 2*Admittance.stderr
  y2s[insig] <- NA
  py <- c(y2 + y2e, rev(y2 - y2e))
  plot(x, y2, col=NA, ylim=range(py), main='Admittance')
  polygon(px, py, col='lightgrey', border=NA)
  lines(x, y2, lty=3)
  lines(x, y2s)
  
  y3 <- y3s <- Phase * 180/pi
  y3s[insig] <- NA
  plot(x, y3, col=NA, ylim=90*c(-1,1), main='Phase')
  lines(x, y3, col='grey')
  lines(x, y3s)
})

# turn off k to get Welch's Overlapping
wcsd <- cross_spectrum(X, Y, k=NULL)

}
