% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmcudaR.R
\name{knn_cuda}
\alias{knn_cuda}
\title{K-Nearest Neighbor Classification using CUDA}
\usage{
knn_cuda(k, samples, centroids, assignments, metric = "L2", device = 0,
  verbosity = 0)
}
\arguments{
\item{k}{The number of neighbors to search for each sample}

\item{samples}{Numeric matrix}

\item{centroids}{Numeric matrix with precalculated clusters' 
centroids}

\item{assignments}{integer vector with sample-cluster 
associations. Indices start from 1.}

\item{metric}{character name of the distance metric to use.
The default is Euclidean (L2), it can be changed to 
"cos" for Sphereical K-means with angular distance. NOTE - 
the samples must be normalized in the latter case.}

\item{device}{integer defining device to use. 1 = first device,
2 = second device, 3 = first & second devices, 0 = use all devices.
Default = 0}

\item{verbosity}{Integer indicating amount of output to see.
0 = silence, 1 = progress logging, 2 = all output}
}
\value{
Integer matrix with neighbor indices of shape [nsamp, k].
}
\description{
k-nearest neighbor classification using
a NVIDIA GPU via CUDA backend
}

