% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_lasso.R
\name{stat.lasso_lambdadiff}
\alias{stat.lasso_lambdadiff}
\title{Importance statistics based on the lasso}
\usage{
stat.lasso_lambdadiff(X, X_k, y, ...)
}
\arguments{
\item{X}{n-by-p matrix of original variables.}

\item{X_k}{n-by-p matrix of knockoff variables.}

\item{y}{vector of length n, containing the response variables. It should be numeric.}

\item{...}{additional arguments specific to \code{glmnet} (see Details).}
}
\value{
A vector of statistics \eqn{W} of length p.
}
\description{
Fit the lasso path and computes the difference statistic
  \deqn{W_j = Z_j - \tilde{Z}_j}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the maximum values of the 
regularization parameter \eqn{\lambda} at which the jth variable 
and its knockoff enter the penalized linear regression model, respectively.
}
\details{
This function uses \code{glmnet} to compute the lasso path
on a fine grid of \eqn{\lambda}'s and is a wrapper around the more general
\link{stat.glmnet_lambdadiff}.

The \code{nlambda} parameter can be used to control the granularity of the 
grid of \eqn{\lambda}'s. The default value of \code{nlambda} is \code{500}.

Unless a lambda sequence is provided by the user, this function generates it on a 
log-linear scale before calling \code{glmnet} (default 'nlambda': 500).

For a complete list of the available additional arguments, see \code{\link[glmnet]{glmnet}}
or \code{\link[lars]{lars}}.
}
\examples{
p=200; n=100; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)
knockoffs = function(X) create.gaussian(X, mu, Sigma)

# Basic usage with default arguments
result = knockoff.filter(X, y, knockoffs=knockoffs, 
                           statistic=stat.lasso_lambdadiff)
print(result$selected)

# Advanced usage with custom arguments
foo = stat.lasso_lambdadiff
k_stat = function(X, X_k, y) foo(X, X_k, y, nlambda=200)
result = knockoff.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics: 
\code{\link{stat.forward_selection}()},
\code{\link{stat.glmnet_coefdiff}()},
\code{\link{stat.glmnet_lambdadiff}()},
\code{\link{stat.lasso_coefdiff_bin}()},
\code{\link{stat.lasso_coefdiff}()},
\code{\link{stat.lasso_lambdadiff_bin}()},
\code{\link{stat.random_forest}()},
\code{\link{stat.sqrt_lasso}()},
\code{\link{stat.stability_selection}()}
}
\concept{statistics}
