% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_pasteText.R
\docType{methods}
\name{pasteText}
\alias{pasteText}
\alias{pasteText,kRp.text-method}
\title{Paste koRpus objects}
\usage{
pasteText(txt, ...)

\S4method{pasteText}{kRp.text}(
  txt,
  replace = c(hon.kRp = "", hoff.kRp = "\\n\\n", p.kRp = "\\n\\n")
)
}
\arguments{
\item{txt}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{...}{Additional options, currently unused.}

\item{replace}{A named character vector to define replacements for \code{koRpus}' internal headline and paragraph tags.}
}
\value{
An atomic character vector.
}
\description{
Paste the text in koRpus objects.
}
\details{
This function takes objects of class \code{kRp.text} and pastes only the actual text as is.
}
\examples{
\dontrun{
  tagged.text.obj <- freq.analysis(tagged.text.obj, corp.freq=my.LCC.data,
      as.feature=TRUE)
  pasteText(tagged.text.obj)
}
}
\keyword{misc}
