% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkonfound.R
\name{mkonfound}
\alias{mkonfound}
\title{Perform meta-analyses including sensitivity analysis}
\usage{
mkonfound(d, t, df, alpha = 0.05, tails = 2, return_plot = FALSE)
}
\arguments{
\item{d}{data.frame or tibble with the t-statistics and associated degrees of freedom}

\item{t}{t-statistic or vector of t-statistics}

\item{df}{degrees of freedom or vector of degrees of freedom associated with the t-statistics in the t argument}

\item{alpha}{probability of rejecting the null hypothesis (defaults to 0.05)}

\item{tails}{integer whether hypothesis testing is one-tailed (1) or two-tailed (2; defaults to 2)}

\item{return_plot}{whether to return a plot of the percent bias; defaults to FALSE}
}
\value{
prints the bias and the number of cases that would have to be replaced with cases for which there is no effect to invalidate the inference for each of the cases in the data.frame
}
\description{
For fitted models, this command carries out sensitivity analysis for a number of models, when their parameters stored in a data.frame.
}
\examples{
d <- read.csv("https://msu.edu/~kenfrank/example\%20dataset\%20for\%20mkonfound.csv")
d <- d[1:3, ] # this is only so that the example runs more quickly
str(d)
mkonfound(d, t, df)
}
