% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ktaucenters_aux.R
\name{ktaucenters_aux}
\alias{ktaucenters_aux}
\title{ktaucenters_aux}
\usage{
ktaucenters_aux(X, K, centers, tolmin, NiterMax)
}
\arguments{
\item{X}{A matrix  of size n x p.}

\item{K}{The number of clusters.}

\item{centers}{matrix of size K x p containing the K initial centers, one at each matrix-row.}

\item{tolmin}{tolerance parameter used for the algorithm stopping rule}

\item{NiterMax}{a maximun number of iterations used for the algorithm stopping rule}
}
\value{
A list including the estimated K centers and labels for the observations
\itemize{
 \item{\code{centers}}{:   matrix of size K x p, with the estimated K centers.}
 \item{\code{cluster}}{: array of size n x 1  integers labels between 1 and K.}
 \item{\code{tauPath}}{: sequence of tau scale values at each iterations.}
 \item{\code{Wni}}{: numeric array of size n x 1 indicating the weights associated to each observation.}
 \item{\code{emptyClusterFlag}}{: a boolean value. True means that in some iteration there were clusters totally empty}
 \item{\code{niter}}{: number of iterations untill convergence is achived or maximun number of iteration is reached}
 \item{\code{di}}{distance of each observation to its assigned cluster-center}
 }
}
\description{
Robust Clustering algorithm based on centers, a robust and efficient version of KMeans.
}
\note{
Some times, if the initial centers are wrong, the algorithm converges to a non-optimal (local) solution.
To avoid that, the algorithm must be run several times. This task is carried out by \code{\link{ktaucenters}}
}
\examples{

# Generate Sintetic data (three cluster well separated)
Z=rnorm(600);
mues=rep(c(0,10,20),200)
X= matrix(Z+mues,ncol=2)

# Applying the algortihm
sal = ktaucenters_aux(
X, K=3, centers=X[sample(1:300,3), ],
tolmin=1e-3, NiterMax=100)

#plot the results
plot(X,type="n")
points(X[sal$cluster==1,],col=1);
points(X[sal$cluster==2,],col=2);
points(X[sal$cluster==3,],col=3);

}
\references{
Gonzalez, J. D., Yohai, V. J., & Zamar, R. H. (2019). 
Robust Clustering Using Tau-Scales. arXiv preprint arXiv:1906.08198.
}
\seealso{
\code{\link{ktaucenters}}
}
