% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_val_labs.R
\name{with_val_labs}
\alias{with_val_labs}
\alias{wvl}
\title{Evaluate an Expression in a Value Labels-on Data Environment}
\usage{
with_val_labs(data, ...)

wvl(data, ...)
}
\arguments{
\item{data}{a data.frame with value-labeled columns.}

\item{...}{additional arguments passed to dots, typically an expression
involving a function called on unquoted variable(s) (see examples).}
}
\value{
the value of the evaluated \code{expr}, with value labels
substituted for variable values.
}
\description{
\code{with_val_labs} wraps a data.frame in \code{use_val_labs} and wraps the resulting
data.frame in \code{base::with} in support of \code{base::with}-like non-standard
evaluation (see examples).

Note: \code{wvl} is a compact alias for \code{with_val_labs}: they do the same thing,
and the former is easier to type
}
\details{
\code{with_val_labs} (see also alias \code{wvl}) is useful for applying certain
nominal-variable-friendly functions (chiefly, \code{table} and the like) to
value-labeled data.frames. See also \code{base::with}. See also \code{tabl},
\code{with_name_labs}, and \code{with_both_labs}.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

# let's add variable VALUE labels for variable "gender"
# note that, if we are labeling a single variable, we can use add_val1()
# distinction between add_val1() and add_val_labs() will become more meaningful
# when we get to our Likert example
df <- add_val1(
  data = df, gender, vals = c(0, 1, 2, 3, 4),
  labs = c("M", "F", "TR", "NB", "Diff-Term"), max.unique.vals = 50
)

# "with_val_labs" - with()-like function that swaps value labels out for value values
# compare with(df, ...) to with_val_labs(df,...)
with(df, table(gender, raceth)) # without labels

# the same data (note that presentation order changes d/t alphabetical ordering)
with_val_labs(df, table(gender, raceth)) # with labels
with(use_val_labs(df), table(gender, raceth)) # above is shorthand for this

# just raceth
with(df, table(raceth)) # with
with_val_labs(df, table(raceth)) # with_val_labs

# another use case
with(df, unique(raceth)) # with
with_val_labs(df, unique(raceth)) # with_val_labs

# another
with(df, modelr::typical(raceth)) # numerical median!
with_val_labs(df, modelr::typical(raceth)) # modal label (not the median!)
}
