% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryimlist.R
\name{summary.imlist}
\alias{summary.imlist}
\title{Pointwise summary of a list of \code{im} objects}
\usage{
\method{summary}{imlist}(object, ..., harmonizeobject = TRUE)
}
\arguments{
\item{object}{A list of \code{im} objects}

\item{...}{Ignored}

\item{harmonizeobject}{If TRUE (default) the pixel dimensions of the images will be harmonized. Otherwise the object will be tested for compatibility.}
}
\value{
A list \code{im} objects containing the pointwise mean, variance and maxima and minima.
}
\description{
This function assumes that \code{im} objects are each realisations of the same (stochastic) object. 
It returns pointwise summaries such as observed sample mean and sample variance.
}
\examples{
# reduce resolution in setcov() for faster (less accurate) computation 
oldopt <- spatstat.options()
spatstat.options("npixel" = 2^4)

obspatterns <- replicate(3, rbdd(10, 0.05, window = square(1)), simplify = FALSE)
ims <- solapply(obspatterns,
 function(x) racscovariance(x, obswin = square(1), estimators = "pickaH", drop = TRUE))
summ <- summary.imlist(ims, harmonizeobject = FALSE)
spatstat.options(oldopt)
}
\author{
Kassel Hingee
}
